/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.ArrayList;
import java.util.List;
import tech.ytsaurus.client.rows.WireTypeUtil;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.skiff.ComplexSchema;
import tech.ytsaurus.skiff.SkiffSchema;
import tech.ytsaurus.skiff.WireType;
import tech.ytsaurus.typeinfo.StructType;
import tech.ytsaurus.typeinfo.TiType;

public class SchemaConverter {
    private SchemaConverter() {
    }

    public static SkiffSchema toSkiffSchema(TableSchema tableSchema) {
        ComplexSchema schema = SkiffSchema.tuple(new ArrayList());
        for (ColumnSchema column : tableSchema.getColumns()) {
            schema.getChildren().add(SchemaConverter.getTiTypeSchema(column.getTypeV3()).setName(column.getName()));
        }
        return schema;
    }

    private static SkiffSchema getTiTypeSchema(TiType tiType) {
        WireType wireType = WireTypeUtil.getWireTypeOf(tiType);
        if (wireType.isSimpleType()) {
            return SkiffSchema.simpleType((WireType)wireType);
        }
        return SchemaConverter.getComplexTiTypeSchema(tiType);
    }

    private static ComplexSchema getComplexTiTypeSchema(TiType tiType) {
        if (tiType.isOptional()) {
            return SkiffSchema.variant8(List.of(SkiffSchema.nothing(), SchemaConverter.getTiTypeSchema(tiType.asOptional().getItem())));
        }
        if (tiType.isStruct()) {
            ComplexSchema schema = SkiffSchema.tuple(new ArrayList());
            for (StructType.Member member : tiType.asStruct().getMembers()) {
                schema.getChildren().add(SchemaConverter.getTiTypeSchema(member.getType()).setName(member.getName()));
            }
            return schema;
        }
        if (tiType.isList()) {
            return SkiffSchema.repeatedVariant8(List.of(SchemaConverter.getTiTypeSchema(tiType.asList().getItem())));
        }
        if (tiType.isDict()) {
            return SkiffSchema.repeatedVariant8(List.of(SkiffSchema.tuple(List.of(SchemaConverter.getTiTypeSchema(tiType.asDict().getKey()), SchemaConverter.getTiTypeSchema(tiType.asDict().getValue())))));
        }
        throw new IllegalStateException("Unsupported TiType: " + tiType);
    }
}

