/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.Objects;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.WireProtocolWriteable;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.tables.TableSchema;

public class UnversionedRowSerializer
implements WireRowSerializer<UnversionedRow> {
    private final TableSchema schema;

    public UnversionedRowSerializer() {
        this(new TableSchema.Builder().setUniqueKeys(false).build());
    }

    public UnversionedRowSerializer(TableSchema schema) {
        this.schema = Objects.requireNonNull(schema);
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    private int getValueId(UnversionedValue value, int[] idMapping) {
        return idMapping == null ? value.getId() : idMapping[value.getId()];
    }

    @Override
    public void serializeRow(UnversionedRow row, WireProtocolWriteable writeable, boolean keyFieldsOnly, boolean aggregate, int[] idMapping) {
        writeable.writeValueCount(row.getValues().size());
        for (UnversionedValue value : row.getValues()) {
            writeable.writeValueHeader(this.getValueId(value, idMapping), value.getType(), value.isAggregate(), value.getLength());
            Object v = value.getValue();
            switch (value.getType()) {
                case INT64: 
                case UINT64: {
                    writeable.onInteger((Long)v);
                    break;
                }
                case DOUBLE: {
                    writeable.onDouble((Double)v);
                    break;
                }
                case BOOLEAN: {
                    writeable.onBoolean((Boolean)v);
                    break;
                }
                case STRING: 
                case COMPOSITE: 
                case ANY: {
                    writeable.onBytes(value.bytesValue());
                    break;
                }
            }
        }
    }
}

