/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.ysontree.YTreeMapNode;

public class UnversionedRowset {
    private final TableSchema schema;
    private final List<UnversionedRow> rows;

    public UnversionedRowset(TableSchema schema, List<UnversionedRow> rows) {
        this.schema = Objects.requireNonNull(schema);
        this.rows = Objects.requireNonNull(rows);
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public List<UnversionedRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public List<YTreeMapNode> getYTreeRows() {
        return this.getYTreeRows(false);
    }

    public List<YTreeMapNode> getYTreeRows(final boolean ignoreSystemColumns) {
        return new AbstractList<YTreeMapNode>(){

            @Override
            public YTreeMapNode get(int index) {
                UnversionedRow row = UnversionedRowset.this.rows.get(index);
                return row != null ? row.toYTreeMap(UnversionedRowset.this.schema, ignoreSystemColumns) : null;
            }

            @Override
            public int size() {
                return UnversionedRowset.this.rows.size();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnversionedRowset)) {
            return false;
        }
        UnversionedRowset that = (UnversionedRowset)o;
        if (!this.schema.equals((Object)that.schema)) {
            return false;
        }
        return this.rows.equals(that.rows);
    }

    public int hashCode() {
        int result = this.schema.hashCode();
        result = 31 * result + this.rows.hashCode();
        return result;
    }

    public String toString() {
        return "UnversionedRowset{schema=" + this.schema + ", rows=" + this.rows + "}";
    }
}

