/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeBooleanNode;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeConvertible;
import tech.ytsaurus.ysontree.YTreeDoubleNode;
import tech.ytsaurus.ysontree.YTreeEntityNode;
import tech.ytsaurus.ysontree.YTreeIntegerNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeStringNode;

public class UnversionedValue
implements YTreeConvertible {
    private final int id;
    private final ColumnValueType type;
    private final boolean aggregate;
    private final Object value;

    public UnversionedValue(int id, ColumnValueType type, boolean aggregate, Object value) {
        switch (Objects.requireNonNull(type)) {
            case INT64: 
            case UINT64: {
                if (value instanceof Long) break;
                throw UnversionedValue.illegalValue(type, value);
            }
            case DOUBLE: {
                if (value instanceof Double) break;
                throw UnversionedValue.illegalValue(type, value);
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw UnversionedValue.illegalValue(type, value);
            }
            case STRING: 
            case COMPOSITE: 
            case ANY: {
                if (value instanceof byte[]) break;
                throw UnversionedValue.illegalValue(type, value);
            }
            default: {
                if (value == null) break;
                throw UnversionedValue.illegalValue(type, value);
            }
        }
        this.id = id;
        this.type = type;
        this.aggregate = aggregate;
        this.value = value;
    }

    private static IllegalArgumentException illegalValue(ColumnValueType type, Object value) {
        return new IllegalArgumentException("Illegal value " + value + "(" + value.getClass() + ") for type " + type);
    }

    public static Object convertValueTo(Object value, ColumnValueType type, SerializationResolver serializationResolver) {
        switch (type) {
            case INT64: {
                if (value == null || value instanceof Long) {
                    return value;
                }
                if (value instanceof YTreeIntegerNode) {
                    return ((YTreeIntegerNode)value).longValue();
                }
                if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    return ((Number)value).longValue();
                }
                if (!(value instanceof YTreeEntityNode)) break;
                return null;
            }
            case UINT64: {
                if (value == null || value instanceof Long) {
                    return value;
                }
                if (value instanceof YTreeIntegerNode) {
                    return ((YTreeIntegerNode)value).longValue();
                }
                if (value instanceof Integer) {
                    return Integer.toUnsignedLong((Integer)value);
                }
                if (value instanceof Short) {
                    return Short.toUnsignedLong((Short)value);
                }
                if (value instanceof Byte) {
                    return Byte.toUnsignedLong((Byte)value);
                }
                if (!(value instanceof YTreeEntityNode)) break;
                return null;
            }
            case DOUBLE: {
                if (value == null || value instanceof Double) {
                    return value;
                }
                if (value instanceof YTreeDoubleNode) {
                    return ((YTreeDoubleNode)value).doubleValue();
                }
                if (value instanceof Float) {
                    return ((Float)value).doubleValue();
                }
                if (!(value instanceof YTreeEntityNode)) break;
                return null;
            }
            case BOOLEAN: {
                if (value == null || value instanceof Boolean) {
                    return value;
                }
                if (value instanceof YTreeBooleanNode) {
                    return ((YTreeNode)value).boolValue();
                }
                if (!(value instanceof YTreeEntityNode)) break;
                return null;
            }
            case STRING: {
                if (value == null || value instanceof byte[]) {
                    return value;
                }
                if (value instanceof YTreeStringNode) {
                    return ((YTreeStringNode)value).bytesValue();
                }
                if (value instanceof String) {
                    return ((String)value).getBytes(StandardCharsets.UTF_8);
                }
                if (!(value instanceof YTreeEntityNode)) break;
                return null;
            }
            case COMPOSITE: 
            case ANY: {
                if (value == null || value instanceof byte[]) {
                    return value;
                }
                return serializationResolver.toTree(value).toBinary();
            }
            default: {
                throw new IllegalArgumentException("Unexpected type " + type);
            }
        }
        throw UnversionedValue.illegalValue(type, value);
    }

    public int getId() {
        return this.id;
    }

    public ColumnValueType getType() {
        return this.type;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public Object getValue() {
        return this.value;
    }

    public int getLength() {
        switch (this.type) {
            case STRING: 
            case COMPOSITE: 
            case ANY: {
                return ((byte[])this.value).length;
            }
        }
        return 0;
    }

    public long longValue() {
        switch (this.type) {
            case INT64: 
            case UINT64: {
                return (Long)this.value;
            }
        }
        throw new IllegalArgumentException(this.type + " is not an integer value");
    }

    public double doubleValue() {
        if (this.type != ColumnValueType.DOUBLE) {
            throw new IllegalArgumentException(this.type + " is not a double value");
        }
        return (Double)this.value;
    }

    public boolean booleanValue() {
        if (this.type != ColumnValueType.BOOLEAN) {
            throw new IllegalArgumentException(this.type + " is not a boolean value");
        }
        return (Boolean)this.value;
    }

    public byte[] bytesValue() {
        switch (this.type) {
            case STRING: 
            case COMPOSITE: 
            case ANY: {
                return (byte[])this.value;
            }
        }
        throw new IllegalArgumentException(this.type + " is not a string-like value");
    }

    public String stringValue() {
        return new String(this.bytesValue(), StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnversionedValue)) {
            return false;
        }
        UnversionedValue other = (UnversionedValue)o;
        if (this.id != other.id) {
            return false;
        }
        if (this.aggregate != other.aggregate) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case INT64: 
            case UINT64: 
            case DOUBLE: 
            case BOOLEAN: {
                return this.value.equals(other.value);
            }
            case STRING: 
            case ANY: {
                return Arrays.equals((byte[])this.value, (byte[])other.value);
            }
        }
        return true;
    }

    private static int valueHashCode(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                return Arrays.hashCode((byte[])value);
            }
            return value.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.aggregate ? 1 : 0);
        result = 31 * result + UnversionedValue.valueHashCode(this.value);
        return result;
    }

    private static String valueString(Object value) {
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        return String.valueOf(value);
    }

    public String toString() {
        return "UnversionedValue{id=" + this.id + ", type=" + this.type + ", aggregate=" + this.aggregate + ", value=" + UnversionedValue.valueString(this.value) + "}";
    }

    public void writeTo(YsonConsumer consumer) {
        switch (this.type) {
            case NULL: {
                consumer.onEntity();
                break;
            }
            case INT64: {
                consumer.onInteger(this.longValue());
                break;
            }
            case UINT64: {
                consumer.onUnsignedInteger(this.longValue());
                break;
            }
            case DOUBLE: {
                consumer.onDouble(this.doubleValue());
                break;
            }
            case BOOLEAN: {
                consumer.onBoolean(this.booleanValue());
                break;
            }
            case STRING: {
                byte[] bytes = this.bytesValue();
                consumer.onString(bytes, 0, bytes.length);
                break;
            }
            case COMPOSITE: 
            case ANY: {
                YTreeBinarySerializer.deserialize((InputStream)new ByteArrayInputStream(this.bytesValue()), (YsonConsumer)consumer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert " + this.type + " to YTree");
            }
        }
    }

    public YTreeNode toYTree() {
        YTreeBuilder builder = YTree.builder();
        this.writeTo((YsonConsumer)builder);
        return builder.build();
    }

    public long toRawBits() {
        switch (this.type) {
            case INT64: 
            case UINT64: {
                return (Long)this.value;
            }
            case DOUBLE: {
                return Double.doubleToRawLongBits((Double)this.value);
            }
            case BOOLEAN: {
                return (Boolean)this.value != false ? 1L : 0L;
            }
        }
        throw new IllegalArgumentException(this.type + " cannot be represented as raw bits");
    }
}

