/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.VersionedValue;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;

public class VersionedRow {
    private final List<Long> writeTimestamps;
    private final List<Long> deleteTimestamps;
    private final List<UnversionedValue> keys;
    private final List<VersionedValue> values;

    public VersionedRow(List<Long> writeTimestamps, List<Long> deleteTimestamps, List<UnversionedValue> keys, List<VersionedValue> values) {
        this.writeTimestamps = Objects.requireNonNull(writeTimestamps);
        this.deleteTimestamps = Objects.requireNonNull(deleteTimestamps);
        this.keys = Objects.requireNonNull(keys);
        this.values = Objects.requireNonNull(values);
    }

    public List<Long> getWriteTimestamps() {
        return Collections.unmodifiableList(this.writeTimestamps);
    }

    public List<Long> getDeleteTimestamps() {
        return Collections.unmodifiableList(this.deleteTimestamps);
    }

    public List<UnversionedValue> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public List<VersionedValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionedRow)) {
            return false;
        }
        VersionedRow that = (VersionedRow)o;
        if (!this.writeTimestamps.equals(that.writeTimestamps)) {
            return false;
        }
        if (!this.deleteTimestamps.equals(that.deleteTimestamps)) {
            return false;
        }
        if (!this.keys.equals(that.keys)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.writeTimestamps.hashCode();
        result = 31 * result + this.deleteTimestamps.hashCode();
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        return "VersionedRow{writeTimestamps=" + this.writeTimestamps + ", deleteTimestamps=" + this.deleteTimestamps + ", keys=" + this.keys + ", values=" + this.values + "}";
    }

    public void writeTo(YsonConsumer consumer, TableSchema schema) {
        consumer.onBeginAttributes();
        consumer.onKeyedItem("write_timestamps");
        consumer.onBeginList();
        Iterator<Object> iterator = this.writeTimestamps.iterator();
        while (iterator.hasNext()) {
            long writeTimestamp = iterator.next();
            consumer.onListItem();
            consumer.onUnsignedInteger(writeTimestamp);
        }
        consumer.onEndList();
        consumer.onKeyedItem("delete_timestamps");
        consumer.onBeginList();
        iterator = this.deleteTimestamps.iterator();
        while (iterator.hasNext()) {
            long deleteTimestamp = iterator.next();
            consumer.onListItem();
            consumer.onUnsignedInteger(deleteTimestamp);
        }
        consumer.onEndList();
        consumer.onEndAttributes();
        consumer.onBeginMap();
        for (UnversionedValue key : this.keys) {
            String name = schema.getColumnName(key.getId());
            consumer.onKeyedItem(name);
            key.writeTo(consumer);
        }
        int lastId = -1;
        for (VersionedValue value : this.values) {
            int id = value.getId();
            if (lastId != id) {
                if (lastId != -1) {
                    consumer.onEndList();
                }
                String name = schema.getColumnName(id);
                consumer.onKeyedItem(name);
                consumer.onBeginList();
                lastId = id;
            }
            consumer.onListItem();
            value.writeTo(consumer);
        }
        if (lastId != -1) {
            consumer.onEndList();
        }
        consumer.onEndMap();
    }

    public YTreeMapNode toYTreeMap(TableSchema schema) {
        YTreeBuilder builder = YTree.builder();
        this.writeTo((YsonConsumer)builder, schema);
        return builder.build().mapNode();
    }
}

