/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.Objects;
import tech.ytsaurus.core.tables.ColumnValueType;

public class WireColumnSchema {
    private final int id;
    private final ColumnValueType type;
    private final boolean aggregate;

    public WireColumnSchema(int id, ColumnValueType type) {
        this(id, type, false);
    }

    public WireColumnSchema(int id, ColumnValueType type, boolean aggregate) {
        this.id = id;
        this.type = Objects.requireNonNull(type);
        this.aggregate = aggregate;
    }

    public int getId() {
        return this.id;
    }

    public ColumnValueType getType() {
        return this.type;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WireColumnSchema)) {
            return false;
        }
        WireColumnSchema that = (WireColumnSchema)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.aggregate != that.aggregate) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.aggregate ? 1 : 0);
        return result;
    }

    public String toString() {
        return "WireColumnSchema{id=" + this.id + ", type=" + this.type + ", aggregate=" + this.aggregate + "}";
    }
}

