/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

public class WireProtocol {
    public static final int WIRE_FORMAT_VERSION = 1;
    public static final int MAX_KEY_COLUMN_COUNT = 32;
    public static final int MAX_VALUES_PER_ROW = 1024;
    public static final int MAX_STRING_VALUE_LENGTH = 0x1000000;
    public static final int MAX_ANY_VALUE_LENGTH = 0x1000000;
    public static final int MAX_COMPOSITE_VALUE_LENGTH = 0x1000000;
    public static final int SERIALIZATION_ALIGNMENT = 8;
    public static final byte AGGREGATE_FLAG = 1;

    private WireProtocol() {
    }

    public static int alignTail(int size) {
        return -size & 7;
    }

    public static int alignUp(int size) {
        return size + WireProtocol.alignTail(size);
    }

    public static int validateRowKeyCount(long keyCount) {
        if (keyCount < 0L || keyCount > 32L) {
            throw new IllegalStateException("Unsupported number of keys " + keyCount + " in a row");
        }
        return (int)keyCount;
    }

    public static int validateRowValueCount(long valueCount) {
        if (valueCount < 0L || valueCount > 1024L) {
            throw new IllegalStateException("Unsupported number of values " + valueCount + " in a row");
        }
        return (int)valueCount;
    }

    public static int validateRowCount(long rowCount) {
        if (rowCount < 0L) {
            throw new IllegalStateException("Unsupported number of rows " + rowCount + " in a rowset");
        }
        return (int)rowCount;
    }

    public static short validateColumnId(int id) {
        if (id < 0 || id > 65535) {
            throw new IllegalStateException("Invalid column id " + id);
        }
        return (short)id;
    }
}

