/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.LongSupplier;
import tech.ytsaurus.client.rows.Bitmap;
import tech.ytsaurus.client.rows.WireColumnSchema;
import tech.ytsaurus.client.rows.WireProtocol;
import tech.ytsaurus.client.rows.WireRowDeserializer;
import tech.ytsaurus.client.rows.WireRowsetDeserializer;
import tech.ytsaurus.client.rows.WireSchemafulRowDeserializer;
import tech.ytsaurus.client.rows.WireSchemafulRowsetDeserializer;
import tech.ytsaurus.client.rows.WireValueDeserializer;
import tech.ytsaurus.client.rows.WireVersionedRowDeserializer;
import tech.ytsaurus.client.rows.WireVersionedRowsetDeserializer;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.TableSchema;

public class WireProtocolReader {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private final List<byte[]> chunks;
    private int nextChunk;
    private byte[] current;
    private int offset;

    public WireProtocolReader(List<byte[]> chunks) {
        this.chunks = chunks;
    }

    public boolean readable() {
        while (this.current == null || this.offset >= this.current.length) {
            if (this.nextChunk >= this.chunks.size()) {
                return false;
            }
            this.current = this.chunks.get(this.nextChunk++);
            this.offset = 0;
        }
        return true;
    }

    private int ensureReadable() {
        if (!this.readable()) {
            throw new BufferUnderflowException();
        }
        return this.current.length - this.offset;
    }

    private void skipRawBytes(int count) {
        while (count > 0) {
            int readable = this.ensureReadable();
            if (readable >= count) {
                this.offset += count;
                return;
            }
            this.offset += readable;
            count -= readable;
        }
    }

    private byte readRawByte() {
        this.ensureReadable();
        return this.current[this.offset++];
    }

    private short readRawShort() {
        int readable = this.ensureReadable();
        if (readable < 2) {
            return (short)(Byte.toUnsignedInt(this.readRawByte()) | Byte.toUnsignedInt(this.readRawByte()) << 8);
        }
        int value = Byte.toUnsignedInt(this.current[this.offset]) | Byte.toUnsignedInt(this.current[this.offset + 1]) << 8;
        this.offset += 2;
        return (short)value;
    }

    private int readRawInt() {
        int readable = this.ensureReadable();
        if (readable < 4) {
            return Byte.toUnsignedInt(this.readRawByte()) | Byte.toUnsignedInt(this.readRawByte()) << 8 | Byte.toUnsignedInt(this.readRawByte()) << 16 | Byte.toUnsignedInt(this.readRawByte()) << 24;
        }
        int value = Byte.toUnsignedInt(this.current[this.offset]) | Byte.toUnsignedInt(this.current[this.offset + 1]) << 8 | Byte.toUnsignedInt(this.current[this.offset + 2]) << 16 | Byte.toUnsignedInt(this.current[this.offset + 3]) << 24;
        this.offset += 4;
        return value;
    }

    private long readRawLong() {
        int readable = this.ensureReadable();
        if (readable < 8) {
            return Byte.toUnsignedLong(this.readRawByte()) | Byte.toUnsignedLong(this.readRawByte()) << 8 | Byte.toUnsignedLong(this.readRawByte()) << 16 | Byte.toUnsignedLong(this.readRawByte()) << 24 | Byte.toUnsignedLong(this.readRawByte()) << 32 | Byte.toUnsignedLong(this.readRawByte()) << 40 | Byte.toUnsignedLong(this.readRawByte()) << 48 | Byte.toUnsignedLong(this.readRawByte()) << 56;
        }
        long value = Byte.toUnsignedLong(this.current[this.offset]) | Byte.toUnsignedLong(this.current[this.offset + 1]) << 8 | Byte.toUnsignedLong(this.current[this.offset + 2]) << 16 | Byte.toUnsignedLong(this.current[this.offset + 3]) << 24 | Byte.toUnsignedLong(this.current[this.offset + 4]) << 32 | Byte.toUnsignedLong(this.current[this.offset + 5]) << 40 | Byte.toUnsignedLong(this.current[this.offset + 6]) << 48 | Byte.toUnsignedLong(this.current[this.offset + 7]) << 56;
        this.offset += 8;
        return value;
    }

    private void alignAfterReading(int size) {
        this.skipRawBytes(WireProtocol.alignTail(size));
    }

    private long readLong() {
        long result = this.readRawLong();
        this.alignAfterReading(8);
        return result;
    }

    private byte[] readBytes(int length) {
        int available;
        byte[] result = new byte[length];
        for (int index = 0; index < length; index += available) {
            available = Math.min(this.ensureReadable(), length - index);
            System.arraycopy(this.current, this.offset, result, index, available);
            this.offset += available;
        }
        this.alignAfterReading(length);
        return result;
    }

    private byte[] readStringData(ColumnValueType type, long length) {
        int limit = 0;
        switch (type) {
            case STRING: {
                limit = 0x1000000;
                break;
            }
            case ANY: {
                limit = 0x1000000;
                break;
            }
            case COMPOSITE: {
                limit = 0x1000000;
                break;
            }
        }
        if (length < 0L || length > (long)limit) {
            throw new IllegalStateException("Unsupported " + type + " data length " + length);
        }
        return this.readBytes((int)length);
    }

    private Bitmap readNullBitmap(int count) {
        Bitmap result = new Bitmap(count);
        int byteCount = 0;
        for (int i = 0; i < result.getChunkCount(); ++i) {
            result.setChunk(i, this.readRawLong());
            byteCount += 8;
        }
        this.alignAfterReading(byteCount);
        return result;
    }

    private void readUnversionedValues(WireValueDeserializer<?> consumer, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            this.readValue(() -> -1L, consumer);
        }
    }

    private void readSchemafulValues(WireValueDeserializer<?> consumer, List<WireColumnSchema> schemaData, int valueCount) {
        Bitmap nullBitmap = this.readNullBitmap(valueCount);
        for (int index = 0; index < valueCount; ++index) {
            WireColumnSchema column = schemaData.get(index);
            consumer.setId(column.getId());
            consumer.setAggregate(column.isAggregate());
            boolean isNull = nullBitmap.getBit(index);
            ColumnValueType type = isNull ? ColumnValueType.NULL : column.getType();
            this.readValueImpl(consumer, type, Integer.MAX_VALUE);
            consumer.build();
        }
    }

    private void readVersionedValues(WireValueDeserializer<?> consumer, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            this.readValue(this::readLong, consumer);
        }
    }

    private <T> void readValueImpl(WireValueDeserializer<T> consumer, ColumnValueType type, int length) {
        consumer.setType(type);
        if (type.isStringLikeType()) {
            byte[] bytes = this.readStringData(type, length == Integer.MAX_VALUE ? this.readLong() : (long)length);
            consumer.onBytes(bytes);
        } else if (type.isValueType()) {
            long rawBits = this.readLong();
            switch (type) {
                case INT64: 
                case UINT64: {
                    consumer.onInteger(rawBits);
                    break;
                }
                case DOUBLE: {
                    consumer.onDouble(Double.longBitsToDouble(rawBits));
                    break;
                }
                case BOOLEAN: {
                    consumer.onBoolean((rawBits & 0xFFL) != 0L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type + " cannot be represented as raw bits");
                }
            }
        } else {
            consumer.onEntity();
        }
    }

    private <T> void readValue(LongSupplier timestampSupplier, WireValueDeserializer<T> consumer) {
        int id = this.readRawShort() & 0xFFFF;
        consumer.setId(id);
        ColumnValueType type = ColumnValueType.fromValue((int)(this.readRawByte() & 0xFF));
        byte flags = this.readRawByte();
        boolean aggregate = (flags & 1) != 0;
        consumer.setAggregate(aggregate);
        int length = this.readRawInt();
        this.alignAfterReading(8);
        this.readValueImpl(consumer, type, length);
        consumer.setTimestamp(timestampSupplier.getAsLong());
        consumer.build();
    }

    private List<Long> readTimestamps(int count) {
        ArrayList<Long> result = new ArrayList<Long>(count);
        int byteCount = 0;
        for (int i = 0; i < count; ++i) {
            result.add(this.readRawLong());
            byteCount += 8;
        }
        this.alignAfterReading(byteCount);
        return result;
    }

    public <T> T readSchemafulRow(WireSchemafulRowDeserializer<T> deserializer) {
        long valueCount = this.readLong();
        if (valueCount == -1L) {
            return null;
        }
        int valueCountInt = WireProtocol.validateRowValueCount(valueCount);
        this.readSchemafulValues(deserializer.onNewRow(valueCountInt), deserializer.getColumnSchema(), valueCountInt);
        return deserializer.onCompleteRow();
    }

    public <T> T readUnversionedRow(WireRowDeserializer<T> deserializer) {
        long valueCount0 = this.readLong();
        if (valueCount0 == -1L) {
            return deserializer.onNullRow();
        }
        int valueCount = WireProtocol.validateRowValueCount(valueCount0);
        WireValueDeserializer<?> consumer = deserializer.onNewRow(valueCount);
        this.readUnversionedValues(consumer, valueCount);
        return deserializer.onCompleteRow();
    }

    public <T> T readVersionedRow(WireVersionedRowDeserializer<T> deserializer) {
        int valueCount = this.readRawInt();
        int keyCount = this.readRawInt();
        if (valueCount == -1 && keyCount == -1) {
            this.alignAfterReading(8);
            return null;
        }
        int writeTimestampCount = this.readRawInt();
        int deleteTimestampCount = this.readRawInt();
        this.alignAfterReading(16);
        WireProtocol.validateRowKeyCount(keyCount);
        WireProtocol.validateRowValueCount(valueCount);
        WireProtocol.validateRowValueCount(writeTimestampCount);
        WireProtocol.validateRowValueCount(deleteTimestampCount);
        deserializer.onWriteTimestamps(this.readTimestamps(writeTimestampCount));
        deserializer.onDeleteTimestamps(this.readTimestamps(deleteTimestampCount));
        WireValueDeserializer<?> keys = deserializer.keys(keyCount);
        this.readSchemafulValues(keys, deserializer.getKeyColumnSchema(), keyCount);
        WireValueDeserializer<?> values = deserializer.values(valueCount);
        this.readVersionedValues(values, valueCount);
        return deserializer.onCompleteRow();
    }

    public int readRowCount() {
        return WireProtocol.validateRowCount(this.readLong());
    }

    public void skipRowCountHeader() {
        this.readRowCount();
    }

    public <T extends WireRowsetDeserializer<V>, V> T readUnversionedRowset(T deserializer) {
        return (T)this.readImpl(deserializer, deserializer::setRowCount, this::readUnversionedRow);
    }

    public <T extends WireSchemafulRowsetDeserializer<V>, V> T readSchemafulRowset(T deserializer) {
        return (T)this.readImpl(deserializer, deserializer::setRowCount, this::readSchemafulRow);
    }

    public <T extends WireVersionedRowsetDeserializer<V>, V> T readVersionedRowset(T deserializer) {
        return (T)this.readImpl(deserializer, deserializer::setRowCount, this::readVersionedRow);
    }

    private <T> T readImpl(T deserializer, IntConsumer rowCountFunction, Consumer<T> readFunction) {
        int rowCount = this.readRowCount();
        rowCountFunction.accept(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            readFunction.accept(deserializer);
        }
        return deserializer;
    }

    public static List<WireColumnSchema> makeSchemaData(TableSchema schema) {
        List columns = schema.getColumns();
        ArrayList<WireColumnSchema> schemaData = new ArrayList<WireColumnSchema>(columns.size());
        for (int id = 0; id < columns.size(); ++id) {
            ColumnSchema column = (ColumnSchema)columns.get(id);
            schemaData.add(new WireColumnSchema(id, column.getType()));
        }
        return schemaData;
    }
}

