/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.rows.Bitmap;
import tech.ytsaurus.client.rows.ChunkedWriter;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.VersionedRow;
import tech.ytsaurus.client.rows.VersionedValue;
import tech.ytsaurus.client.rows.WireProtocol;
import tech.ytsaurus.client.rows.WireProtocolWriteable;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.TableSchema;

public class WireProtocolWriter {
    private static final int INITIAL_BUFFER_CAPACITY = 1024;
    private static final int PREALLOCATE_BLOCK_SIZE = 4096;
    private final WireProtocolWriteable writeable;
    private final ChunkedWriter writer;
    private ByteBuffer current;
    private int currentStart;

    public WireProtocolWriter() {
        this(new ArrayList<byte[]>());
    }

    public WireProtocolWriter(List<byte[]> output) {
        this(output, 0x10000000);
    }

    WireProtocolWriter(List<byte[]> output, int limitChunkSize) {
        this.writer = new ChunkedWriter(output, 0, limitChunkSize);
        this.reserve(1024);
        this.writeable = new WireProtocolWriteable(){

            @Override
            public void onEntity() {
                throw new IllegalStateException("Value must be provided");
            }

            @Override
            public void onInteger(long value) {
                WireProtocolWriter.this.writeLong(value);
            }

            @Override
            public void onBoolean(boolean value) {
                WireProtocolWriter.this.writeLong(value ? 1L : 0L);
            }

            @Override
            public void onDouble(double value) {
                WireProtocolWriter.this.writeLong(Double.doubleToRawLongBits(value));
            }

            @Override
            public void onBytes(byte[] bytes) {
                WireProtocolWriter.this.writeBytes(bytes);
            }

            @Override
            public void writeValueCount(int valueCount) {
                WireProtocolWriter.this.reserveAligned(8);
                WireProtocolWriter.this.writer.mark(WireProtocolWriter.this.current.position());
                WireProtocolWriter.this.writeLong(WireProtocol.validateRowValueCount(valueCount));
            }

            @Override
            public void overwriteValueCount(int valueCount) {
                WireProtocolWriter.this.writer.getMarker().writeToMark(WireProtocolWriter.this.current, ByteOrder.LITTLE_ENDIAN, WireProtocol.validateRowValueCount(valueCount));
            }

            @Override
            public void writeValueHeader(int columnId, ColumnValueType type, boolean aggregate, int length) {
                WireProtocolWriter.this.writeUnversionedValueHeader(columnId, type, aggregate, length);
            }
        };
    }

    public List<byte[]> finish() {
        this.flushCurrent();
        return this.writer.flush();
    }

    private void flushCurrent() {
        if (this.current != null) {
            this.writer.advance(this.current.position() - this.currentStart);
            this.current = null;
        }
    }

    private void reserve(int size) {
        if (this.current != null && this.current.remaining() >= size) {
            return;
        }
        this.flushCurrent();
        this.writer.reserve(Math.max(size, 4096));
        this.current = ByteBuffer.wrap(this.writer.buffer(), this.writer.offset(), this.writer.remaining()).order(ByteOrder.LITTLE_ENDIAN);
        this.currentStart = this.current.position();
    }

    private void reserveAligned(int size) {
        this.reserve(WireProtocol.alignUp(size));
    }

    private void alignAfterWriting(int size) {
        this.current.position(this.current.position() + WireProtocol.alignTail(size));
    }

    private void writeLong(long value) {
        this.reserveAligned(8);
        this.current.putLong(value);
        this.alignAfterWriting(8);
    }

    private void writeBytes(byte[] value) {
        this.reserveAligned(value.length);
        this.current.put(value);
        this.alignAfterWriting(value.length);
    }

    private void writeNullBitmap(List<UnversionedValue> row) {
        Bitmap bitmap = new Bitmap(row.size());
        for (int i = 0; i < row.size(); ++i) {
            if (row.get(i).getType() != ColumnValueType.NULL) continue;
            bitmap.setBit(i);
        }
        int byteCount = 8 * bitmap.getChunkCount();
        this.reserveAligned(byteCount);
        for (int i = 0; i < bitmap.getChunkCount(); ++i) {
            this.current.putLong(bitmap.getChunk(i));
        }
        this.alignAfterWriting(byteCount);
    }

    private void writeSchemafulValue(UnversionedValue value) {
        switch (value.getType()) {
            case INT64: 
            case UINT64: 
            case DOUBLE: 
            case BOOLEAN: {
                this.writeLong(value.toRawBits());
                break;
            }
            case STRING: 
            case ANY: {
                byte[] data = value.bytesValue();
                this.writeLong(data.length);
                this.writeBytes(data);
                break;
            }
        }
    }

    private void writeSchemafulValues(List<UnversionedValue> values) {
        this.writeNullBitmap(values);
        for (UnversionedValue value : values) {
            this.writeSchemafulValue(value);
        }
    }

    public void writeUnversionedValueHeader(int columnId, ColumnValueType type, boolean aggregate, int length) {
        this.reserveAligned(8);
        this.current.putShort(WireProtocol.validateColumnId(columnId));
        this.current.put((byte)type.getValue());
        this.current.put(aggregate ? (byte)1 : 0);
        this.current.putInt(length);
        this.alignAfterWriting(8);
    }

    private void writeUnversionedValueHeader(UnversionedValue value) {
        this.writeUnversionedValueHeader(value.getId(), value.getType(), value.isAggregate(), value.getLength());
    }

    private void writeUnversionedValue(UnversionedValue value) {
        this.writeUnversionedValueHeader(value);
        switch (value.getType()) {
            case INT64: 
            case UINT64: 
            case DOUBLE: 
            case BOOLEAN: {
                this.writeLong(value.toRawBits());
                break;
            }
            case STRING: 
            case ANY: {
                this.writeBytes(value.bytesValue());
                break;
            }
        }
    }

    private void writeVersionedValue(VersionedValue value) {
        this.writeUnversionedValue(value);
        this.writeLong(value.getTimestamp());
    }

    private void writeVersionedValues(List<VersionedValue> values) {
        for (VersionedValue value : values) {
            this.writeVersionedValue(value);
        }
    }

    public void writeMessage(MessageLite message) {
        int size = message.getSerializedSize();
        this.writeLong(size);
        this.reserveAligned(size);
        try {
            message.writeTo(CodedOutputStream.newInstance((byte[])this.current.array(), (int)(this.current.arrayOffset() + this.current.position()), (int)size));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.current.position(this.current.position() + size);
        this.alignAfterWriting(size);
    }

    public void writeSchemafulRow(UnversionedRow row) {
        if (row != null) {
            this.writeLong(WireProtocol.validateRowValueCount(row.getValues().size()));
            this.writeSchemafulValues(row.getValues());
        } else {
            this.writeLong(-1L);
        }
    }

    public <T> void writeUnversionedRow(T row, WireRowSerializer<T> serializer) {
        this.writeUnversionedRow(row, serializer, null);
    }

    public <T> void writeUnversionedRow(T row, WireRowSerializer<T> serializer, int[] idMapping) {
        this.writeUnversionedRow(row, serializer, false, false, idMapping);
    }

    public <T> void writeUnversionedRow(T row, WireRowSerializer<T> serializer, boolean keyFieldsOnly) {
        this.writeUnversionedRow(row, serializer, keyFieldsOnly, false, null);
    }

    public <T> void writeUnversionedRow(T row, WireRowSerializer<T> serializer, boolean keyFieldsOnly, boolean aggregate, int[] idMapping) {
        if (row != null) {
            serializer.serializeRow(row, this.writeable, keyFieldsOnly, aggregate, idMapping);
        } else {
            this.writeLong(-1L);
        }
    }

    private void writeTimestamps(List<Long> timestamps) {
        int byteCount = 8 * timestamps.size();
        this.reserveAligned(byteCount);
        for (long timestamp : timestamps) {
            this.current.putLong(timestamp);
        }
        this.alignAfterWriting(byteCount);
    }

    public void writeVersionedRow(VersionedRow row) {
        if (row != null) {
            WireProtocol.validateRowKeyCount(row.getKeys().size());
            WireProtocol.validateRowValueCount(row.getValues().size());
            WireProtocol.validateRowValueCount(row.getWriteTimestamps().size());
            WireProtocol.validateRowValueCount(row.getDeleteTimestamps().size());
            this.reserveAligned(16);
            this.current.putInt(row.getValues().size());
            this.current.putInt(row.getKeys().size());
            this.current.putInt(row.getWriteTimestamps().size());
            this.current.putInt(row.getDeleteTimestamps().size());
            this.alignAfterWriting(16);
            this.writeTimestamps(row.getWriteTimestamps());
            this.writeTimestamps(row.getDeleteTimestamps());
            this.writeSchemafulValues(row.getKeys());
            this.writeVersionedValues(row.getValues());
        } else {
            this.writeLong(-1L);
        }
    }

    public void writeRowCount(int rowCount) {
        this.writeLong(WireProtocol.validateRowCount(rowCount));
    }

    public void writeSchemafulRowset(List<UnversionedRow> rows) {
        this.writeRowCount(rows.size());
        for (UnversionedRow row : rows) {
            this.writeSchemafulRow(row);
        }
    }

    public <T> void writeUnversionedRowset(List<T> rows, WireRowSerializer<T> serializer) {
        this.writeUnversionedRowset(rows, serializer, (int[])null);
    }

    public <T> void writeUnversionedRowset(List<T> rows, WireRowSerializer<T> serializer, int[] idMapping) {
        this.writeUnversionedRowset(rows, serializer, i -> false, i -> false, idMapping);
    }

    public <T> void writeUnversionedRowsetWithoutCount(List<T> rows, WireRowSerializer<T> serializer, int[] idMapping) {
        for (T row : rows) {
            this.writeUnversionedRow(row, serializer, idMapping);
        }
    }

    public <T> void writeUnversionedRowset(List<T> rows, WireRowSerializer<T> serializer, Function<Integer, Boolean> keyFieldsOnlyFunction, Function<Integer, Boolean> isAggregateFunction) {
        this.writeUnversionedRowset(rows, serializer, keyFieldsOnlyFunction, isAggregateFunction, null);
    }

    public <T> void writeUnversionedRowset(List<T> rows, WireRowSerializer<T> serializer, Function<Integer, Boolean> func) {
        this.writeUnversionedRowset(rows, serializer, func, i -> false, null);
    }

    public <T> void writeUnversionedRowset(List<T> rows, WireRowSerializer<T> serializer, Function<Integer, Boolean> isKeyFieldsOnlyFunction, Function<Integer, Boolean> isAggregateFunction, int[] idMapping) {
        int rowCount = rows.size();
        this.writeRowCount(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.writeUnversionedRow(rows.get(i), serializer, isKeyFieldsOnlyFunction.apply(i), isAggregateFunction.apply(i), idMapping);
        }
    }

    public void writeVersionedRowset(List<VersionedRow> rows) {
        this.writeRowCount(rows.size());
        for (VersionedRow row : rows) {
            this.writeVersionedRow(row);
        }
    }

    public void writeTableSchema(TableSchema schema) {
        this.writeMessage((MessageLite)ApiServiceUtil.serializeTableSchema(schema));
    }
}

