/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import tech.ytsaurus.client.rpc.Codec;

abstract class AbstractLZCodec<Compressor, Decompressor>
extends Codec {
    private static final int THEADER_SIZE = 8;
    private static final int TBLOCK_HEADER_SIZE = 8;
    private static final int HEADERS_SIZE = 16;
    private static final int SIGNATURE_V1 = 0x40000001;
    private static final int MAX_BLOCK_SIZE = 0x40000000;

    AbstractLZCodec() {
    }

    @Override
    public byte[] compress(byte[] src) {
        int uncompressedSize = src.length;
        if (uncompressedSize > 0x40000000) {
            throw new IllegalArgumentException("unsupported block size: " + uncompressedSize + " must be smaller than 1073741824");
        }
        Compressor compressor = this.getCompressor();
        int compressedSizeBound = this.calcCompressedSizeBound(compressor, uncompressedSize);
        byte[] dst = new byte[16 + compressedSizeBound];
        int compressedSize = this.compress(compressor, src, 0, uncompressedSize, dst, 16);
        ByteBuffer.wrap(dst, 0, 16).order(ByteOrder.LITTLE_ENDIAN).putInt(0x40000001).putInt(uncompressedSize).putInt(compressedSize).putInt(uncompressedSize);
        return Arrays.copyOf(dst, 16 + compressedSize);
    }

    @Override
    public byte[] decompress(byte[] src) {
        byte[] output;
        int srcLength = src.length;
        if (srcLength == 0) {
            return src;
        }
        ByteBuffer bb = ByteBuffer.wrap(src, 0, 16).order(ByteOrder.LITTLE_ENDIAN);
        int signature = bb.getInt();
        int uncompressedSize = bb.getInt();
        if (uncompressedSize > 0x40000000) {
            throw new IllegalArgumentException("unsupported block size: " + uncompressedSize + " must be smaller than 1073741824");
        }
        int blockCompressedSize = bb.getInt();
        int blockUncompressedSize = bb.getInt();
        if (signature != 0x40000001) {
            throw new IllegalArgumentException("unsupported signature: " + signature + ", supports SignatureV1 only");
        }
        if (uncompressedSize != blockUncompressedSize) {
            throw new IllegalArgumentException("unsupported compression: only single block expected");
        }
        if (blockCompressedSize != srcLength - 16) {
            throw new IllegalArgumentException("unsupported compression: expect block size " + (srcLength - 16) + ", received " + blockCompressedSize);
        }
        Decompressor decompressor = this.getDecompressor();
        int compressedLen = this.decompress(decompressor, src, 16, output = new byte[uncompressedSize], 0, uncompressedSize);
        if (compressedLen != blockCompressedSize) {
            throw new IllegalArgumentException("broken stream: expect block size " + blockCompressedSize + ", decompressed " + compressedLen);
        }
        return output;
    }

    abstract Compressor getCompressor();

    abstract int calcCompressedSizeBound(Compressor var1, int var2);

    abstract int compress(Compressor var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    abstract Decompressor getDecompressor();

    abstract int decompress(Decompressor var1, byte[] var2, int var3, byte[] var4, int var5, int var6);
}

