/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import tech.ytsaurus.client.rpc.BalancingDestinationMetricsHolder;
import tech.ytsaurus.client.rpc.DefaultRpcBusClient;

public class BalancingDestinationMetricsHolderImpl
implements BalancingDestinationMetricsHolder {
    public static final BalancingDestinationMetricsHolderImpl INSTANCE = new BalancingDestinationMetricsHolderImpl();
    private static final MetricRegistry METRICS = SharedMetricRegistries.getOrCreate((String)"ytclient");

    @Override
    public double getLocal99thPercentile(String destinationName) {
        return BalancingDestinationMetricsHolderImpl.getForLocal(destinationName).getSnapshot().get99thPercentile();
    }

    @Override
    public void updateLocal(String destinationName, long interval) {
        BalancingDestinationMetricsHolderImpl.getForLocal(destinationName).update(interval);
    }

    @Override
    public void updateDc(String dc, long interval) {
        BalancingDestinationMetricsHolderImpl.getForDc(dc).update(interval);
    }

    private static Histogram getForLocal(String destinationName) {
        return METRICS.histogram(MetricRegistry.name(DefaultRpcBusClient.class, (String[])new String[]{"ping", destinationName}));
    }

    private static Histogram getForDc(String dc) {
        return METRICS.histogram(MetricRegistry.name(DefaultRpcBusClient.class, (String[])new String[]{"ping", dc}));
    }
}

