/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.misc.ScheduledSerializedExecutorService;
import tech.ytsaurus.client.rpc.BalancingResponseHandlerMetricsHolder;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.utils.ExceptionUtils;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpc.TRequestHeaderOrBuilder;
import tech.ytsaurus.rpc.TResponseHeader;

class FailoverRpcExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FailoverRpcExecutor.class);
    private static final TimeoutException TIMEOUT_EXCEPTION = new TimeoutException();
    private final ScheduledSerializedExecutorService serializedExecutorService;
    private final BalancingResponseHandlerMetricsHolder metricsHolder;
    private final RpcClientPool clientPool;
    private final RetryPolicy retryPolicy;
    private final long failoverTimeout;
    private final long globalDeadline;
    private final RpcRequest<?> request;
    private final GUID originalRequestId;
    private final RpcClientResponseHandler baseHandler;
    private final RpcOptions options;
    private final CompletableFuture<Result> result = new CompletableFuture();
    private final MutableState mutableState;

    private FailoverRpcExecutor(ScheduledExecutorService executorService, RpcClientPool clientPool, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        this.serializedExecutorService = new ScheduledSerializedExecutorService(executorService);
        this.clientPool = clientPool;
        this.metricsHolder = options.getResponseMetricsHolder();
        this.retryPolicy = options.getRetryPolicyFactory().get();
        this.failoverTimeout = options.getFailoverTimeout().toMillis();
        this.globalDeadline = System.currentTimeMillis() + options.getGlobalTimeout().toMillis();
        this.request = request;
        this.originalRequestId = RpcRequest.getRequestId((TRequestHeaderOrBuilder)request.header);
        this.baseHandler = handler;
        this.options = options;
        this.mutableState = new MutableState();
    }

    private RpcClientRequestControl execute() {
        this.serializedExecutorService.execute(() -> this.mutableState.executeImpl(new FailoverResponseHandler()));
        this.result.whenComplete((result, error) -> {
            if (error != null) {
                logger.warn("Request {} failed with error; OriginalRequestId: {}, Error: {}", new Object[]{this.request, this.originalRequestId, error.toString()});
            }
            this.serializedExecutorService.submit(this.mutableState::cancel);
            this.handleResult((Result)result, (Throwable)error);
        });
        return () -> this.result.cancel(true);
    }

    public static RpcClientRequestControl execute(ScheduledExecutorService executorService, RpcClientPool clientPool, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        return new FailoverRpcExecutor(executorService, clientPool, request, handler, options).execute();
    }

    private void send(RpcClientResponseHandler handler) {
        logger.trace("Peeking connection from pool; OriginalRequestId: {}", (Object)this.originalRequestId);
        this.peekClient().whenCompleteAsync((client, error) -> {
            if (this.result.isDone()) {
                return;
            }
            if (error == null) {
                logger.trace("Successfully got connection from pool; Proxy: {}; OriginalRequestId: {}", (Object)client.getAddressString(), (Object)this.originalRequestId);
                this.mutableState.sendImpl((RpcClient)client, handler);
                return;
            }
            logger.warn("Failed to get RpcClient from pool; OriginalRequestId: {}", (Object)this.originalRequestId, error);
            this.mutableState.softAbort((Throwable)error);
        }, (Executor)this.serializedExecutorService);
    }

    private CompletableFuture<RpcClient> peekClient() {
        CompletableFuture<RpcClient> clientFuture = new CompletableFuture<RpcClient>();
        this.result.whenComplete((o, error) -> {
            if (!clientFuture.isDone()) {
                clientFuture.completeExceptionally(new RuntimeException("Request was finished before the RpcClient was received", (Throwable)error));
            }
        });
        this.tryPeekClient(clientFuture);
        return clientFuture;
    }

    private void tryPeekClient(CompletableFuture<RpcClient> clientFuture) {
        if (clientFuture.isDone()) {
            return;
        }
        this.clientPool.peekClient(this.result).whenComplete((client, error) -> {
            if (clientFuture.isDone()) {
                return;
            }
            if (error == null) {
                clientFuture.complete((RpcClient)client);
                return;
            }
            if (ExceptionUtils.hasCause((Throwable)error, TimeoutException.class)) {
                this.tryPeekClient(clientFuture);
                return;
            }
            clientFuture.completeExceptionally((Throwable)error);
        });
    }

    private void handleResult(Result result, Throwable error) {
        if (error == null) {
            this.baseHandler.onResponse(result.client, result.header, result.data);
        } else {
            this.baseHandler.onError(error);
        }
    }

    private void onGlobalTimeout() {
        this.result.completeExceptionally(new TimeoutException(String.format("Request has timed out; OriginalRequestId: %s", this.originalRequestId)));
    }

    private class MutableState {
        private final List<RpcClientRequestControl> cancellation = new ArrayList<RpcClientRequestControl>();
        private int requestsSent = 0;
        private int requestsError = 0;
        private boolean stopped = false;
        private Throwable lastRequestError = null;

        private MutableState() {
        }

        public void softAbort(Throwable error) {
            this.stopped = true;
            if (this.requestsError == this.requestsSent) {
                if (this.lastRequestError == null) {
                    FailoverRpcExecutor.this.result.completeExceptionally(error);
                } else {
                    FailoverRpcExecutor.this.result.completeExceptionally(this.lastRequestError);
                }
            }
        }

        public void onRequestError(Throwable error, FailoverResponseHandler handler) {
            ++this.requestsError;
            this.lastRequestError = error;
            if (!FailoverRpcExecutor.this.result.isDone()) {
                Optional<Duration> backoffDuration = FailoverRpcExecutor.this.retryPolicy.getBackoffDuration(error, FailoverRpcExecutor.this.options);
                boolean isRetriable = backoffDuration.isPresent();
                if (!isRetriable) {
                    FailoverRpcExecutor.this.result.completeExceptionally(error);
                } else if (!this.stopped) {
                    FailoverRpcExecutor.this.serializedExecutorService.schedule(() -> FailoverRpcExecutor.this.send(handler), backoffDuration.get().toMillis(), TimeUnit.MILLISECONDS);
                } else if (this.requestsError == this.requestsSent) {
                    FailoverRpcExecutor.this.result.completeExceptionally(error);
                }
            }
        }

        public void sendImpl(RpcClient client, RpcClientResponseHandler handler) {
            GUID currentRequestId;
            long now = System.currentTimeMillis();
            if (now >= FailoverRpcExecutor.this.globalDeadline) {
                FailoverRpcExecutor.this.onGlobalTimeout();
                return;
            }
            if (this.requestsSent > 0) {
                FailoverRpcExecutor.this.metricsHolder.failoverInc();
            }
            ++this.requestsSent;
            FailoverRpcExecutor.this.retryPolicy.onNewAttempt();
            FailoverRpcExecutor.this.metricsHolder.inflightInc();
            FailoverRpcExecutor.this.metricsHolder.totalInc();
            TRequestHeader.Builder requestHeader = FailoverRpcExecutor.this.request.header.toBuilder();
            requestHeader.setTimeout((FailoverRpcExecutor.this.globalDeadline - now) * 1000L);
            if (this.requestsSent > 1) {
                currentRequestId = GUID.create();
                requestHeader.setRequestId(RpcUtil.toProto(currentRequestId));
                requestHeader.setRetry(true);
            } else {
                currentRequestId = FailoverRpcExecutor.this.originalRequestId;
                requestHeader.setRequestId(RpcUtil.toProto(currentRequestId));
            }
            RpcRequest<?> copy = FailoverRpcExecutor.this.request.copy(requestHeader.build());
            this.cancellation.add(client.send(client, copy, handler, FailoverRpcExecutor.this.options));
            logger.debug("Starting new attempt; AttemptId: {}, OriginalRequestId: {}, RequestId: {}", new Object[]{this.requestsSent, FailoverRpcExecutor.this.originalRequestId, currentRequestId});
            ScheduledFuture<?> scheduled = FailoverRpcExecutor.this.serializedExecutorService.schedule(() -> {
                if (!FailoverRpcExecutor.this.result.isDone()) {
                    boolean isTimeoutRetriable;
                    Optional<Duration> backoffDuration = FailoverRpcExecutor.this.retryPolicy.getBackoffDuration(TIMEOUT_EXCEPTION, FailoverRpcExecutor.this.options);
                    boolean bl = isTimeoutRetriable = !this.stopped && backoffDuration.isPresent();
                    if (isTimeoutRetriable) {
                        FailoverRpcExecutor.this.serializedExecutorService.schedule(() -> FailoverRpcExecutor.this.send(handler), backoffDuration.get().toMillis(), TimeUnit.MILLISECONDS);
                    }
                }
            }, FailoverRpcExecutor.this.failoverTimeout, TimeUnit.MILLISECONDS);
            this.cancellation.add(() -> scheduled.cancel(true));
        }

        public void executeImpl(RpcClientResponseHandler handler) {
            long globalDelay = FailoverRpcExecutor.this.globalDeadline - System.currentTimeMillis();
            ScheduledFuture<?> scheduled = FailoverRpcExecutor.this.serializedExecutorService.schedule(() -> FailoverRpcExecutor.this.onGlobalTimeout(), globalDelay, TimeUnit.MILLISECONDS);
            this.cancellation.add(() -> scheduled.cancel(true));
            FailoverRpcExecutor.this.send(handler);
        }

        public void cancel() {
            for (RpcClientRequestControl control : this.cancellation) {
                FailoverRpcExecutor.this.metricsHolder.inflightDec();
                control.cancel();
            }
        }
    }

    private class FailoverResponseHandler
    implements RpcClientResponseHandler {
        private FailoverResponseHandler() {
        }

        @Override
        public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
            FailoverRpcExecutor.this.result.complete(new Result(sender, header, attachments));
        }

        @Override
        public void onError(Throwable error) {
            FailoverRpcExecutor.this.serializedExecutorService.submit(() -> FailoverRpcExecutor.this.mutableState.onRequestError(error, this));
        }

        @Override
        public void onCancel(CancellationException cancel) {
            FailoverRpcExecutor.this.result.completeExceptionally(cancel);
        }
    }

    private static class Result {
        final RpcClient client;
        final TResponseHeader header;
        final List<byte[]> data;

        Result(RpcClient client, TResponseHeader header, List<byte[]> data) {
            this.client = client;
            this.header = header;
            this.data = data;
        }
    }
}

