/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.Codec;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpc.TResponseHeader;

@NonNullApi
@NonNullFields
public class LazyResponse<ResponseType extends MessageLite>
implements RpcClientResponse<ResponseType> {
    private final Parser<ResponseType> parser;
    @Nullable
    private byte[] bodyData;
    @Nullable
    private ResponseType bodyMessage;
    private final List<byte[]> attachments;
    private final RpcClient sender;
    @Nullable
    private final Compression compression;

    public LazyResponse(Parser<ResponseType> parser, byte[] body, List<byte[]> attachments, RpcClient sender, @Nullable TResponseHeader responseHeader) {
        this.parser = parser;
        this.bodyData = body;
        this.sender = Objects.requireNonNull(sender);
        this.compression = responseHeader != null && responseHeader.hasCodec() ? Compression.fromValue(responseHeader.getCodec()) : null;
        if (this.compression != null) {
            Codec codec = Codec.codecFor(this.compression);
            this.attachments = attachments.stream().map(codec::decompress).collect(Collectors.toList());
        } else {
            this.attachments = attachments;
        }
    }

    @Override
    public synchronized ResponseType body() {
        if (this.bodyMessage == null) {
            this.bodyMessage = this.compression != null ? (MessageLite)RpcUtil.parseMessageBodyWithCompression(this.bodyData, this.parser, this.compression) : (MessageLite)RpcUtil.parseMessageBodyWithEnvelope(this.bodyData, this.parser);
            this.bodyData = null;
        }
        return this.bodyMessage;
    }

    @Override
    public List<byte[]> attachments() {
        return this.attachments;
    }

    @Override
    public RpcClient sender() {
        return this.sender;
    }
}

