/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import tech.ytsaurus.client.rpc.AbstractLZCodec;

class Lz4Codec
extends AbstractLZCodec<LZ4Compressor, LZ4FastDecompressor> {
    private final boolean hc;
    private final LZ4Factory factory = LZ4Factory.fastestInstance();

    Lz4Codec(boolean hc) {
        this.hc = hc;
    }

    @Override
    LZ4Compressor getCompressor() {
        return this.hc ? this.factory.highCompressor() : this.factory.fastCompressor();
    }

    @Override
    int calcCompressedSizeBound(LZ4Compressor compressor, int uncompressedSize) {
        return compressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    int compress(LZ4Compressor compressor, byte[] src, int srcPos, int srcLength, byte[] dst, int dstPos) {
        return compressor.compress(src, srcPos, srcLength, dst, dstPos);
    }

    @Override
    LZ4FastDecompressor getDecompressor() {
        return this.factory.fastDecompressor();
    }

    @Override
    int decompress(LZ4FastDecompressor decompressor, byte[] src, int srcPos, byte[] dst, int dstPos, int dstLen) {
        return decompressor.decompress(src, srcPos, dst, dstPos, dstLen);
    }
}

