/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.FailoverRpcExecutor;
import tech.ytsaurus.client.rpc.LazyResponse;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpc.TResponseHeader;

@NonNullApi
public class RequestWithResponseBuilder<RequestType extends MessageLite.Builder, ResponseType extends MessageLite>
implements RpcClientRequestBuilder<RequestType, ResponseType> {
    private final TRequestHeader.Builder header;
    private final RequestType body;
    private final List<byte[]> attachments = new ArrayList<byte[]>();
    @Nullable
    private List<byte[]> compressedAttachments = null;
    @Nullable
    private Compression compressedAttachmentsCodec = null;
    private final RpcOptions options;
    private final Parser<ResponseType> parser;

    public RequestWithResponseBuilder(TRequestHeader.Builder header, RequestType body, Parser<ResponseType> parser, RpcOptions options) {
        this.header = header;
        this.body = body;
        this.options = options;
        this.parser = parser;
    }

    @Override
    public RpcOptions getOptions() {
        return this.options;
    }

    @Override
    public TRequestHeader.Builder header() {
        return this.header;
    }

    @Override
    public RequestType body() {
        return this.body;
    }

    @Override
    public List<byte[]> attachments() {
        return this.attachments;
    }

    @Override
    public void setCompressedAttachments(Compression rpcCompression, List<byte[]> attachments) {
        this.compressedAttachments = attachments;
        this.compressedAttachmentsCodec = rpcCompression;
    }

    @Override
    public RpcRequest<?> getRpcRequest() {
        if (this.compressedAttachments != null) {
            if (!this.attachments.isEmpty()) {
                throw new RuntimeException("Both attachments and compressedAttachments are set");
            }
            return new RpcRequest<MessageLite>(this.header.build(), this.body.build(), this.compressedAttachmentsCodec, this.compressedAttachments);
        }
        return new RpcRequest<MessageLite>(this.header.build(), this.body.build(), this.attachments);
    }

    @Override
    public CompletableFuture<RpcClientResponse<ResponseType>> invoke(RpcClient client) {
        CompletableFuture<RpcClientResponse<ResponseType>> result = new CompletableFuture<RpcClientResponse<ResponseType>>();
        try {
            RpcClientResponseHandler handler = this.createHandler(result);
            RpcClientRequestControl control = client.send(client, this.getRpcRequest(), handler, this.getOptions());
            result.whenComplete((ignoredResult, ignoredException) -> control.cancel());
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public CompletableFuture<RpcClientResponse<ResponseType>> invokeVia(ScheduledExecutorService executor, RpcClientPool clientPool) {
        CompletableFuture<RpcClientResponse<ResponseType>> result = new CompletableFuture<RpcClientResponse<ResponseType>>();
        try {
            RpcClientResponseHandler handler = this.createHandler(result);
            RpcClientRequestControl control = FailoverRpcExecutor.execute(executor, clientPool, this.getRpcRequest(), handler, this.getOptions());
            result.whenComplete((ignoredResult, ignoredException) -> control.cancel());
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    public RpcClientResponseHandler createHandler(final CompletableFuture<RpcClientResponse<ResponseType>> result) {
        return new RpcClientResponseHandler(){

            @Override
            public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
                if (!result.isDone()) {
                    if (attachments.size() < 1 || attachments.get(0) == null) {
                        this.onError(new IllegalStateException("Received response without a body"));
                        return;
                    }
                    result.complete(new LazyResponse(RequestWithResponseBuilder.this.parser, attachments.get(0), new ArrayList<byte[]>(attachments.subList(1, attachments.size())), sender, header));
                }
            }

            @Override
            public void onError(Throwable error) {
                result.completeExceptionally(error);
            }

            @Override
            public void onCancel(CancellationException cancel) {
                result.completeExceptionally(cancel);
            }
        };
    }

    public String toString() {
        return String.format("%s/%s/%s", this.getService(), this.getMethod(), this.getRequestId());
    }
}

