/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcClientWrapper;
import tech.ytsaurus.client.rpc.RpcCompression;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.rpc.TRequestHeader;

public class RpcClientWithCompression
extends RpcClientWrapper {
    private final RpcCompression compression;

    public RpcClientWithCompression(RpcClient client, RpcCompression compression) {
        super(client);
        this.compression = compression;
    }

    private void patchHeader(TRequestHeader.Builder header) {
        if (!header.hasRequestCodec()) {
            header.setRequestCodec(this.compression.getRequestCodecId().orElse(Compression.None).getValue());
        }
        if (!header.hasResponseCodec()) {
            header.setResponseCodec(this.compression.getResponseCodecId().orElse(Compression.None).getValue());
        }
    }

    @Override
    public RpcClientRequestControl send(RpcClient sender, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        TRequestHeader.Builder header = request.header.toBuilder();
        this.patchHeader(header);
        return super.send(sender, request.copy(header.build()), handler, options);
    }

    @Override
    public RpcClientStreamControl startStream(RpcClient sender, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options) {
        TRequestHeader.Builder header = request.header.toBuilder();
        this.patchHeader(header);
        return super.startStream(sender, request.copy(header.build()), consumer, options);
    }

    @Override
    public String toString() {
        Compression out;
        Compression in = this.compression.getRequestCodecId().orElse(null);
        if (in == (out = (Compression)this.compression.getResponseCodecId().orElse(null))) {
            if (in == Compression.None) {
                return super.toString();
            }
            return in + "@" + super.toString();
        }
        return in + "/" + out + "@" + super.toString();
    }
}

