/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.lang.NonNullFields;

@NonNullFields
public class RpcClientWrapper
implements RpcClient {
    protected final RpcClient innerClient;

    public RpcClientWrapper(@Nonnull RpcClient innerClient) {
        this.innerClient = Objects.requireNonNull(innerClient);
    }

    @Override
    public void ref() {
        this.innerClient.ref();
    }

    @Override
    public void unref() {
        this.innerClient.unref();
    }

    @Override
    public void close() {
        this.innerClient.close();
    }

    @Override
    public RpcClientRequestControl send(RpcClient sender, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        return this.innerClient.send(sender, request, handler, options);
    }

    @Override
    public RpcClientStreamControl startStream(RpcClient sender, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options) {
        return this.innerClient.startStream(sender, request, consumer, options);
    }

    @Override
    public String destinationName() {
        return this.innerClient.destinationName();
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.innerClient.executor();
    }

    @Override
    @Nullable
    public String getAddressString() {
        return this.innerClient.getAddressString();
    }

    public String toString() {
        return this.innerClient.toString();
    }
}

