/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import tech.ytsaurus.client.DiscoveryMethod;
import tech.ytsaurus.client.ProxySelector;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.rpc.BalancingResponseHandlerMetricsHolder;
import tech.ytsaurus.client.rpc.BalancingResponseHandlerMetricsHolderImpl;
import tech.ytsaurus.client.rpc.DefaultRpcFailoverPolicy;
import tech.ytsaurus.client.rpc.RpcFailoverPolicy;
import tech.ytsaurus.client.rpc.TestingOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class RpcOptions {
    private boolean defaultRequestAck = true;
    @Nullable
    private Duration acknowledgementTimeout = Duration.ofSeconds(15L);
    private Duration globalTimeout = Duration.ofMillis(60000L);
    private Duration failoverTimeout = Duration.ofMillis(30000L);
    private Duration proxyUpdateTimeout = Duration.ofMillis(60000L);
    private int channelPoolSize = 3;
    private TestingOptions testingOptions = new TestingOptions();
    private Duration minBackoffTime = Duration.ofSeconds(3L);
    private Duration maxBackoffTime = Duration.ofSeconds(30L);
    private int windowSize = 0x2000000;
    @Nullable
    private Duration writeTimeout = Duration.ofMillis(60000L);
    @Nullable
    private Duration readTimeout = Duration.ofMillis(60000L);
    private Supplier<RetryPolicy> retryPolicyFactory = () -> RetryPolicy.attemptLimited(3, RetryPolicy.fromRpcFailoverPolicy(new DefaultRpcFailoverPolicy()));
    private BalancingResponseHandlerMetricsHolder responseMetricsHolder = new BalancingResponseHandlerMetricsHolderImpl();
    private boolean traceEnabled = false;
    private boolean traceSampled = false;
    private boolean traceDebug = false;
    private DiscoveryMethod preferableDiscoveryMethod = DiscoveryMethod.RPC;
    private ProxySelector rpcProxySelector = ProxySelector.random();

    public RpcOptions() {
    }

    public RpcOptions(RpcOptions options) {
        this.defaultRequestAck = options.getDefaultRequestAck();
        this.acknowledgementTimeout = options.getAcknowledgementTimeout().orElse(null);
        this.globalTimeout = options.getGlobalTimeout();
        this.failoverTimeout = options.getFailoverTimeout();
        this.proxyUpdateTimeout = options.getProxyUpdateTimeout();
        this.channelPoolSize = options.getChannelPoolSize();
        this.testingOptions = options.getTestingOptions();
        this.minBackoffTime = options.getMinBackoffTime();
        this.maxBackoffTime = options.getMaxBackoffTime();
        this.windowSize = options.getStreamingWindowSize();
        this.writeTimeout = options.getStreamingWriteTimeout().orElse(null);
        this.readTimeout = options.getStreamingReadTimeout().orElse(null);
        this.retryPolicyFactory = options.getRetryPolicyFactory();
        this.responseMetricsHolder = options.getResponseMetricsHolder();
        this.traceEnabled = options.getTrace();
        this.traceSampled = options.getTraceSampled();
        this.traceDebug = options.getTraceDebug();
        this.preferableDiscoveryMethod = options.getPreferableDiscoveryMethod();
        this.rpcProxySelector = options.getRpcProxySelector();
    }

    public boolean getTrace() {
        return this.traceEnabled;
    }

    public RpcOptions setTrace(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public boolean getTraceSampled() {
        return this.traceSampled;
    }

    public RpcOptions setTraceSampled(boolean traceSampled) {
        this.traceSampled = traceSampled;
        return this;
    }

    public boolean getTraceDebug() {
        return this.traceDebug;
    }

    public RpcOptions setTraceDebug(boolean traceDebug) {
        this.traceDebug = traceDebug;
        return this;
    }

    @Deprecated
    public Duration getDefaultTimeout() {
        return this.getGlobalTimeout();
    }

    @Deprecated
    public RpcOptions setDefaultTimeout(Duration defaultTimeout) {
        return this.setGlobalTimeout(defaultTimeout);
    }

    public boolean getDefaultRequestAck() {
        return this.defaultRequestAck;
    }

    public RpcOptions setDefaultRequestAck(boolean defaultRequestAck) {
        this.defaultRequestAck = defaultRequestAck;
        return this;
    }

    public TestingOptions getTestingOptions() {
        return this.testingOptions;
    }

    public RpcOptions setTestingOptions(TestingOptions testingOptions) {
        this.testingOptions = testingOptions;
        return this;
    }

    public Duration getFailoverTimeout() {
        return this.failoverTimeout;
    }

    public RpcOptions setFailoverTimeout(Duration failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
        return this;
    }

    public Duration getGlobalTimeout() {
        return this.globalTimeout;
    }

    public RpcOptions setGlobalTimeout(Duration globalTimeout) {
        this.globalTimeout = globalTimeout;
        return this;
    }

    public Duration getProxyUpdateTimeout() {
        return this.proxyUpdateTimeout;
    }

    public RpcOptions setProxyUpdateTimeout(Duration timeout) {
        this.proxyUpdateTimeout = timeout;
        return this;
    }

    public RpcOptions setStreamingWindowSize(int bytes) {
        this.windowSize = bytes;
        return this;
    }

    public int getStreamingWindowSize() {
        return this.windowSize;
    }

    public RpcOptions setStreamingWriteTimeout(Duration timeout) {
        this.writeTimeout = timeout;
        return this;
    }

    public Optional<Duration> getStreamingWriteTimeout() {
        return Optional.ofNullable(this.writeTimeout);
    }

    public RpcOptions setStreamingReadTimeout(@Nullable Duration timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public Optional<Duration> getStreamingReadTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    @Deprecated
    public RpcOptions setFailoverPolicy(RpcFailoverPolicy failoverPolicy) {
        this.retryPolicyFactory = () -> RetryPolicy.attemptLimited(3, RetryPolicy.fromRpcFailoverPolicy(failoverPolicy));
        return this;
    }

    public Supplier<RetryPolicy> getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public RpcOptions setRetryPolicyFactory(Supplier<RetryPolicy> retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
        return this;
    }

    public RpcOptions setResponseMetricsHolder(BalancingResponseHandlerMetricsHolder responseMetricsHolder) {
        this.responseMetricsHolder = responseMetricsHolder;
        return this;
    }

    public BalancingResponseHandlerMetricsHolder getResponseMetricsHolder() {
        return this.responseMetricsHolder;
    }

    public int getChannelPoolSize() {
        return this.channelPoolSize;
    }

    public RpcOptions setChannelPoolSize(int channelPoolSize) {
        this.channelPoolSize = channelPoolSize;
        return this;
    }

    public DiscoveryMethod getPreferableDiscoveryMethod() {
        return this.preferableDiscoveryMethod;
    }

    public void setPreferableDiscoveryMethod(DiscoveryMethod preferableDiscoveryMethod) {
        this.preferableDiscoveryMethod = preferableDiscoveryMethod;
    }

    public Optional<Duration> getAcknowledgementTimeout() {
        return Optional.ofNullable(this.acknowledgementTimeout);
    }

    public RpcOptions setAcknowledgementTimeout(@Nullable Duration acknowledgementTimeout) {
        this.acknowledgementTimeout = acknowledgementTimeout;
        return this;
    }

    public RpcOptions setMinBackoffTime(Duration minBackoffTime) {
        this.minBackoffTime = Objects.requireNonNull(minBackoffTime);
        return this;
    }

    public RpcOptions setMaxBackoffTime(Duration maxBackoffTime) {
        this.maxBackoffTime = Objects.requireNonNull(maxBackoffTime);
        return this;
    }

    public Duration getMinBackoffTime() {
        return this.minBackoffTime;
    }

    public Duration getMaxBackoffTime() {
        return this.maxBackoffTime;
    }

    public ProxySelector getRpcProxySelector() {
        return this.rpcProxySelector;
    }

    public RpcOptions setRpcProxySelector(@Nullable ProxySelector rpcProxySelector) {
        if (rpcProxySelector == null) {
            this.rpcProxySelector = ProxySelector.random();
            return this;
        }
        this.rpcProxySelector = rpcProxySelector;
        return this;
    }
}

