/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestHeader;

public class RpcRequestsTestingController {
    private final Map<GUID, List<CapturedRequest>> requestIdToRequest = new HashMap<GUID, List<CapturedRequest>>();
    private final Map<String, List<GUID>> methodToRequestIds = new HashMap<String, List<GUID>>();
    private final List<GUID> startedTransactions = new ArrayList<GUID>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(TRequestHeader requestHeader, Object requestBody) {
        RpcRequestsTestingController rpcRequestsTestingController = this;
        synchronized (rpcRequestsTestingController) {
            GUID requestId = RpcUtil.fromProto((TGuidOrBuilder)requestHeader.getRequestId());
            if (!this.requestIdToRequest.containsKey(requestId)) {
                this.requestIdToRequest.put(requestId, new ArrayList());
            }
            this.requestIdToRequest.get(requestId).add(new CapturedRequest(requestHeader, requestBody));
            String method = requestHeader.getMethod();
            if (!this.methodToRequestIds.containsKey(method)) {
                this.methodToRequestIds.put(method, new ArrayList());
            }
            this.methodToRequestIds.get(method).add(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CapturedRequest> getRequestsByMethod(String method) {
        RpcRequestsTestingController rpcRequestsTestingController = this;
        synchronized (rpcRequestsTestingController) {
            if (!this.methodToRequestIds.containsKey(method)) {
                return Collections.emptyList();
            }
            List<GUID> requestIds = this.methodToRequestIds.get(method);
            ArrayList<CapturedRequest> result = new ArrayList<CapturedRequest>();
            for (GUID requestId : requestIds) {
                result.addAll((Collection<CapturedRequest>)this.requestIdToRequest.get(requestId));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStartedTransaction(GUID transactionId) {
        RpcRequestsTestingController rpcRequestsTestingController = this;
        synchronized (rpcRequestsTestingController) {
            this.startedTransactions.add(transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GUID> getStartedTransactions() {
        RpcRequestsTestingController rpcRequestsTestingController = this;
        synchronized (rpcRequestsTestingController) {
            return new ArrayList<GUID>(this.startedTransactions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RpcRequestsTestingController rpcRequestsTestingController = this;
        synchronized (rpcRequestsTestingController) {
            this.requestIdToRequest.clear();
            this.methodToRequestIds.clear();
        }
    }

    public static class CapturedRequest {
        private final TRequestHeader header;
        private final Object body;

        public CapturedRequest(TRequestHeader header, Object body) {
            this.header = header;
            this.body = body;
        }

        public TRequestHeader getHeader() {
            return this.header;
        }

        public Object getBody() {
            return this.body;
        }
    }
}

