/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.sync.SyncApiServiceClientImpl;
import tech.ytsaurus.client.sync.SyncTransactionalClientImpl;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;

public class SyncApiServiceTransaction
extends SyncTransactionalClientImpl
implements AutoCloseable {
    private final ApiServiceTransaction transaction;

    private SyncApiServiceTransaction(ApiServiceTransaction transaction) {
        super(transaction);
        this.transaction = transaction;
    }

    public static SyncApiServiceTransaction wrap(ApiServiceTransaction transaction) {
        return new SyncApiServiceTransaction(transaction);
    }

    public SyncApiServiceClientImpl getClient() {
        return SyncApiServiceClientImpl.wrap(this.transaction.getClient());
    }

    public GUID getId() {
        return this.transaction.getId();
    }

    public TransactionalOptions getTransactionalOptions() {
        return this.transaction.getTransactionalOptions();
    }

    public YtTimestamp getStartTimestamp() {
        return this.transaction.getStartTimestamp();
    }

    public boolean isPing() {
        return this.transaction.isPing();
    }

    public boolean isSticky() {
        return this.transaction.isSticky();
    }

    public void stopPing() {
        this.transaction.stopPing();
    }

    public void ping() {
        this.transaction.ping().join();
    }

    public void commit() {
        this.transaction.commit().join();
    }

    public void abort() {
        ((CompletableFuture)this.transaction.abort()).join();
    }

    @Override
    public void close() {
        this.transaction.close();
    }
}

