/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.io.IOException;
import tech.ytsaurus.client.FileReader;
import tech.ytsaurus.client.sync.SyncFileReader;

class SyncFileReaderImpl
extends SyncFileReader {
    private final FileReader reader;
    private byte[] buf;
    private int pos;

    private SyncFileReaderImpl(FileReader reader) {
        this.reader = reader;
        this.buf = new byte[0];
    }

    static SyncFileReader wrap(FileReader reader) {
        return new SyncFileReaderImpl(reader);
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.buf.length) {
            this.reader.readyEvent().join();
            try {
                if (this.reader.canRead()) {
                    this.buf = this.reader.read();
                    this.pos = 0;
                } else {
                    this.buf = new byte[0];
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.buf.length != 0 ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int available() throws IOException {
        return this.buf.length - this.pos;
    }

    @Override
    public long revision() {
        try {
            return this.reader.revision();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.reader.close().join();
    }
}

