/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.sync.SyncTableReader;

class SyncTableReaderImpl<T>
implements SyncTableReader<T> {
    private final AsyncReader<T> reader;
    private Iterator<T> iterator;
    private boolean noMoreRows;

    private SyncTableReaderImpl(AsyncReader<T> reader) {
        this.reader = reader;
        this.iterator = Collections.emptyIterator();
    }

    static <T> SyncTableReader<T> wrap(AsyncReader<T> reader) {
        return new SyncTableReaderImpl<T>(reader);
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.noMoreRows) {
            return false;
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        List<T> rows = this.reader.next().join();
        if (rows == null || rows.size() == 0) {
            this.noMoreRows = true;
            return false;
        }
        this.iterator = rows.iterator();
        return true;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

