/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.request.AbstractLookupRowsRequest;
import tech.ytsaurus.client.request.AdvanceConsumer;
import tech.ytsaurus.client.request.CheckPermission;
import tech.ytsaurus.client.request.ConcatenateNodes;
import tech.ytsaurus.client.request.CopyNode;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.ExistsNode;
import tech.ytsaurus.client.request.GetFileFromCache;
import tech.ytsaurus.client.request.GetFileFromCacheResult;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.LinkNode;
import tech.ytsaurus.client.request.ListNode;
import tech.ytsaurus.client.request.LockNode;
import tech.ytsaurus.client.request.LockNodeResult;
import tech.ytsaurus.client.request.MapOperation;
import tech.ytsaurus.client.request.MapReduceOperation;
import tech.ytsaurus.client.request.MergeOperation;
import tech.ytsaurus.client.request.MoveNode;
import tech.ytsaurus.client.request.MultiLookupRowsRequest;
import tech.ytsaurus.client.request.MultiTablePartition;
import tech.ytsaurus.client.request.PartitionTables;
import tech.ytsaurus.client.request.PutFileToCache;
import tech.ytsaurus.client.request.PutFileToCacheResult;
import tech.ytsaurus.client.request.ReadFile;
import tech.ytsaurus.client.request.ReadTable;
import tech.ytsaurus.client.request.ReduceOperation;
import tech.ytsaurus.client.request.RemoteCopyOperation;
import tech.ytsaurus.client.request.RemoveNode;
import tech.ytsaurus.client.request.SelectRowsRequest;
import tech.ytsaurus.client.request.SetNode;
import tech.ytsaurus.client.request.SortOperation;
import tech.ytsaurus.client.request.StartOperation;
import tech.ytsaurus.client.request.VanillaOperation;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rows.VersionedRowset;
import tech.ytsaurus.client.sync.SyncFileReader;
import tech.ytsaurus.client.sync.SyncFileReaderImpl;
import tech.ytsaurus.client.sync.SyncFileWriter;
import tech.ytsaurus.client.sync.SyncFileWriterImpl;
import tech.ytsaurus.client.sync.SyncOperation;
import tech.ytsaurus.client.sync.SyncOperationImpl;
import tech.ytsaurus.client.sync.SyncTableReader;
import tech.ytsaurus.client.sync.SyncTableReaderImpl;
import tech.ytsaurus.client.sync.SyncTableWriter;
import tech.ytsaurus.client.sync.SyncTableWriterImpl;
import tech.ytsaurus.client.sync.SyncTransactionalClient;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.rpcproxy.TCheckPermissionResult;
import tech.ytsaurus.ysontree.YTreeNode;

abstract class SyncTransactionalClientImpl
implements SyncTransactionalClient {
    private final TransactionalClient client;

    protected SyncTransactionalClientImpl(TransactionalClient client) {
        this.client = client;
    }

    @Override
    public TCheckPermissionResult checkPermission(CheckPermission req) {
        return this.client.checkPermission(req).join();
    }

    @Override
    public LockNodeResult lockNode(LockNode req) {
        return this.client.lockNode(req).join();
    }

    @Override
    public void concatenateNodes(ConcatenateNodes req) {
        this.client.concatenateNodes(req).join();
    }

    @Override
    public GUID copyNode(CopyNode req) {
        return this.client.copyNode(req).join();
    }

    @Override
    public GUID createNode(CreateNode req) {
        return this.client.createNode(req).join();
    }

    @Override
    public Boolean existsNode(ExistsNode req) {
        return this.client.existsNode(req).join();
    }

    @Override
    public GetFileFromCacheResult getFileFromCache(GetFileFromCache req) {
        return this.client.getFileFromCache(req).join();
    }

    @Override
    public YTreeNode getNode(GetNode req) {
        return this.client.getNode(req).join();
    }

    @Override
    public GUID linkNode(LinkNode req) {
        return this.client.linkNode(req).join();
    }

    @Override
    public YTreeNode listNode(ListNode req) {
        return this.client.listNode(req).join();
    }

    @Override
    public UnversionedRowset lookupRows(AbstractLookupRowsRequest<?, ?> req) {
        return this.client.lookupRows(req).join();
    }

    @Override
    public <T> List<T> lookupRows(AbstractLookupRowsRequest<?, ?> req, YTreeRowSerializer<T> serializer) {
        return this.client.lookupRows(req, serializer).join();
    }

    @Override
    public List<UnversionedRowset> multiLookupRows(MultiLookupRowsRequest req) {
        return this.client.multiLookupRows(req).join();
    }

    @Override
    public <T> CompletableFuture<List<List<T>>> multiLookupRows(MultiLookupRowsRequest req, YTreeRowSerializer<T> serializer) {
        return this.client.multiLookupRows(req, serializer);
    }

    @Override
    public SyncOperation map(MapOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.map(req).join()));
    }

    @Override
    public SyncOperation reduce(ReduceOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.reduce(req).join()));
    }

    @Override
    public SyncOperation mapReduce(MapReduceOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.mapReduce(req).join()));
    }

    @Override
    public SyncOperation merge(MergeOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.merge(req).join()));
    }

    @Override
    public SyncOperation sort(SortOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.sort(req).join()));
    }

    @Override
    public SyncOperation vanilla(VanillaOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.vanilla(req).join()));
    }

    @Override
    public SyncOperation remoteCopy(RemoteCopyOperation req) {
        return this.getIfSuccessOrElseThrow(new SyncOperationImpl(this.client.remoteCopy(req).join()));
    }

    @Override
    public SyncOperation startMap(MapOperation req) {
        return new SyncOperationImpl(this.client.startMap(req).join());
    }

    @Override
    public SyncOperation startReduce(ReduceOperation req) {
        return new SyncOperationImpl(this.client.startReduce(req).join());
    }

    @Override
    public SyncOperation startMapReduce(MapReduceOperation req) {
        return new SyncOperationImpl(this.client.startMapReduce(req).join());
    }

    @Override
    public SyncOperation startMerge(MergeOperation req) {
        return new SyncOperationImpl(this.client.startMerge(req).join());
    }

    @Override
    public SyncOperation startSort(SortOperation req) {
        return new SyncOperationImpl(this.client.startSort(req).join());
    }

    @Override
    public SyncOperation startVanilla(VanillaOperation req) {
        return new SyncOperationImpl(this.client.startVanilla(req).join());
    }

    @Override
    public SyncOperation startRemoteCopy(RemoteCopyOperation req) {
        return new SyncOperationImpl(this.client.startRemoteCopy(req).join());
    }

    @Override
    public GUID startOperation(StartOperation req) {
        return this.client.startOperation(req).join();
    }

    @Override
    public GUID moveNode(MoveNode req) {
        return this.client.moveNode(req).join();
    }

    @Override
    public List<MultiTablePartition> partitionTables(PartitionTables req) {
        return this.client.partitionTables(req).join();
    }

    @Override
    public void advanceConsumer(AdvanceConsumer req) {
        this.client.advanceConsumer(req).join();
    }

    @Override
    public PutFileToCacheResult putFileToCache(PutFileToCache req) {
        return this.client.putFileToCache(req).join();
    }

    @Override
    public SyncFileReader readFile(ReadFile req) {
        return SyncFileReaderImpl.wrap(this.client.readFile(req).join());
    }

    @Override
    public <T> SyncTableReader<T> readTable(ReadTable<T> req) {
        return SyncTableReaderImpl.wrap(this.client.readTableV2(req).join());
    }

    @Override
    public SyncFileWriter writeFile(WriteFile req) {
        return SyncFileWriterImpl.wrap(this.client.writeFile(req).join());
    }

    @Override
    public <T> SyncTableWriter<T> writeTable(WriteTable<T> req) {
        return SyncTableWriterImpl.wrap(this.client.writeTableV2(req).join());
    }

    @Override
    public void removeNode(RemoveNode req) {
        this.client.removeNode(req).join();
    }

    @Override
    public UnversionedRowset selectRows(SelectRowsRequest req) {
        return this.client.selectRows(req).join();
    }

    @Override
    public <T> List<T> selectRows(SelectRowsRequest req, YTreeRowSerializer<T> serializer) {
        return this.client.selectRows(req, serializer).join();
    }

    @Override
    public <T> void selectRows(SelectRowsRequest req, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        this.client.selectRows(req, serializer, consumer).join();
    }

    @Override
    public void setNode(SetNode req) {
        this.client.setNode(req).join();
    }

    @Override
    public VersionedRowset versionedLookupRows(AbstractLookupRowsRequest<?, ?> req) {
        return this.client.versionedLookupRows(req).join();
    }

    public String toString() {
        return this.client.toString();
    }

    private SyncOperation getIfSuccessOrElseThrow(SyncOperation operation) {
        operation.watchAndThrowIfNotSuccess();
        return operation;
    }
}

