/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.StringInfo;
import javassist.bytecode.Utf8Info;

public class YTsaurusBytecodeUtils {
    private YTsaurusBytecodeUtils() {
    }

    public static void updateUtf8Constant(ConstPool constPool, int n, String string) {
        Utf8Info utf8Info = (Utf8Info)constPool.getItem(n);
        if (utf8Info == null) {
            throw new IllegalArgumentException("Const at id " + n + " was not found");
        }
        utf8Info.string = string;
    }

    public static int findStringConstant(ConstPool constPool, Predicate<String> predicate) {
        for (int i = 1; i < constPool.getSize(); ++i) {
            int n = constPool.getTag(i);
            if (n != 8 || !predicate.test(constPool.getStringInfo(i))) continue;
            return i;
        }
        throw new NoSuchElementException("Can't find a string constant that satisfies supplied predicate");
    }

    public static int getUtf8ConstantId(ConstPool constPool, int n) {
        ConstInfo constInfo = constPool.getItem(n);
        if (constInfo instanceof StringInfo) {
            return ((StringInfo)constInfo).string;
        }
        throw new IllegalArgumentException("getUtf8ConstantId is applicable only for string constants");
    }

    public static StackMapTable addStackMapTableFrames(StackMapTable stackMapTable, List<Integer> list, int n, int n2) throws BadBytecode {
        StackMapTableFrameAdder stackMapTableFrameAdder = new StackMapTableFrameAdder(stackMapTable.get(), list, n, n2);
        byte[] byArray = stackMapTableFrameAdder.doit();
        return new StackMapTable(stackMapTable.constPool, byArray);
    }

    private static class StackMapTableFrameAdder
    extends StackMapTable.SimpleCopy {
        private int offset = -1;
        private boolean processed = false;
        private final int start;
        private final int insertLength;
        private final List<Integer> positions;

        public StackMapTableFrameAdder(byte[] byArray, List<Integer> list, int n, int n2) {
            super(byArray);
            this.positions = list;
            this.start = n;
            this.insertLength = n2;
        }

        private int incOffset(int n) {
            this.offset += n + 1;
            if (!this.processed && this.offset > this.start) {
                int n2 = this.offset - n - 1;
                for (int n3 : this.positions) {
                    super.sameFrame(0, n3 - n2 - 1);
                    n2 = n3;
                }
                this.processed = true;
                return n - this.insertLength;
            }
            return n;
        }

        public void sameFrame(int n, int n2) {
            super.sameFrame(n, this.incOffset(n2));
        }

        public void sameLocals(int n, int n2, int n3, int n4) {
            super.sameLocals(n, this.incOffset(n2), n3, n4);
        }

        public void chopFrame(int n, int n2, int n3) {
            super.chopFrame(n, this.incOffset(n2), n3);
        }

        public void appendFrame(int n, int n2, int[] nArray, int[] nArray2) {
            super.appendFrame(n, this.incOffset(n2), nArray, nArray2);
        }

        public void fullFrame(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
            super.fullFrame(n, this.incOffset(n2), nArray, nArray2, nArray3, nArray4);
        }
    }
}

