/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.common.utils;

import org.apache.spark.unsafe.Platform;

public class CityHashImpl {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long k3 = -3942382747735136937L;
    private static final long kMul = -7070675565921424023L;

    private static long toLongLE(byte[] byArray, int n) {
        return ((long)byArray[n + 7] << 56) + ((long)(byArray[n + 6] & 0xFF) << 48) + ((long)(byArray[n + 5] & 0xFF) << 40) + ((long)(byArray[n + 4] & 0xFF) << 32) + ((long)(byArray[n + 3] & 0xFF) << 24) + (long)((byArray[n + 2] & 0xFF) << 16) + (long)((byArray[n + 1] & 0xFF) << 8) + (long)((byArray[n + 0] & 0xFF) << 0);
    }

    private static int toIntLE(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 0] & 0xFF) << 0);
    }

    private static long fetch64(byte[] byArray, int n) {
        return CityHashImpl.toLongLE(byArray, n);
    }

    private static int fetch32(byte[] byArray, int n) {
        return CityHashImpl.toIntLE(byArray, n);
    }

    private static long rotate(long l, int n) {
        return n == 0 ? l : l >>> n | l << 64 - n;
    }

    private static long rotateByAtLeast1(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private static long shiftMix(long l) {
        return l ^ l >>> 47;
    }

    private static long hash128to64(long l, long l2) {
        long l3 = (l ^ l2) * -7070675565921424023L;
        l3 ^= l3 >>> 47;
        long l4 = (l2 ^ l3) * -7070675565921424023L;
        l4 ^= l4 >>> 47;
        return l4 *= -7070675565921424023L;
    }

    private static long hashLen16(long l, long l2) {
        return CityHashImpl.hash128to64(l, l2);
    }

    private static long hashLen0to16(byte[] byArray, int n, int n2) {
        if (n2 > 8) {
            long l = CityHashImpl.fetch64(byArray, n + 0);
            long l2 = CityHashImpl.fetch64(byArray, n + n2 - 8);
            return CityHashImpl.hashLen16(l, CityHashImpl.rotateByAtLeast1(l2 + (long)n2, n2)) ^ l2;
        }
        if (n2 >= 4) {
            long l = 0xFFFFFFFFL & (long)CityHashImpl.fetch32(byArray, n + 0);
            return CityHashImpl.hashLen16((l << 3) + (long)n2, 0xFFFFFFFFL & (long)CityHashImpl.fetch32(byArray, n + n2 - 4));
        }
        if (n2 > 0) {
            int n3 = byArray[n + 0] & 0xFF;
            int n4 = byArray[n + (n2 >>> 1)] & 0xFF;
            int n5 = byArray[n + n2 - 1] & 0xFF;
            int n6 = n3 + (n4 << 8);
            int n7 = n2 + (n5 << 2);
            return CityHashImpl.shiftMix((long)n6 * -7286425919675154353L ^ (long)n7 * -3942382747735136937L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLen17to32(byte[] byArray, int n, int n2) {
        long l = CityHashImpl.fetch64(byArray, n + 0) * -5435081209227447693L;
        long l2 = CityHashImpl.fetch64(byArray, n + 8);
        long l3 = CityHashImpl.fetch64(byArray, n + n2 - 8) * -7286425919675154353L;
        long l4 = CityHashImpl.fetch64(byArray, n + n2 - 16) * -4348849565147123417L;
        return CityHashImpl.hashLen16(CityHashImpl.rotate(l - l2, 43) + CityHashImpl.rotate(l3, 30) + l4, l + CityHashImpl.rotate(l2 ^ 0xC949D7C7509E6557L, 20) - l3 + (long)n2);
    }

    private static long[] weakHashLen32WithSeeds(long l, long l2, long l3, long l4, long l5, long l6) {
        l6 = CityHashImpl.rotate(l6 + (l5 += l) + l4, 21);
        long l7 = l5;
        l5 += l2;
        return new long[]{l5 + l4, (l6 += CityHashImpl.rotate(l5 += l3, 44)) + l7};
    }

    private static long[] weakHashLen32WithSeeds(byte[] byArray, int n, long l, long l2) {
        return CityHashImpl.weakHashLen32WithSeeds(CityHashImpl.fetch64(byArray, n + 0), CityHashImpl.fetch64(byArray, n + 8), CityHashImpl.fetch64(byArray, n + 16), CityHashImpl.fetch64(byArray, n + 24), l, l2);
    }

    private static long hashLen33to64(byte[] byArray, int n, int n2) {
        long l = CityHashImpl.fetch64(byArray, n + 24);
        long l2 = CityHashImpl.fetch64(byArray, n + 0) + (CityHashImpl.fetch64(byArray, n + n2 - 16) + (long)n2) * -4348849565147123417L;
        long l3 = CityHashImpl.rotate(l2 + l, 52);
        long l4 = CityHashImpl.rotate(l2, 37);
        long l5 = (l2 += CityHashImpl.fetch64(byArray, n + 16)) + l;
        long l6 = l3 + CityHashImpl.rotate(l2, 31) + (l4 += CityHashImpl.rotate(l2 += CityHashImpl.fetch64(byArray, n + 8), 7));
        l2 = CityHashImpl.fetch64(byArray, n + 16) + CityHashImpl.fetch64(byArray, n + n2 - 32);
        l = CityHashImpl.fetch64(byArray, n + n2 - 8);
        l3 = CityHashImpl.rotate(l2 + l, 52);
        l4 = CityHashImpl.rotate(l2, 37);
        long l7 = (l2 += CityHashImpl.fetch64(byArray, n + n2 - 16)) + l;
        long l8 = l3 + CityHashImpl.rotate(l2, 31) + (l4 += CityHashImpl.rotate(l2 += CityHashImpl.fetch64(byArray, n + n2 - 24), 7));
        long l9 = CityHashImpl.shiftMix((l5 + l8) * -7286425919675154353L + (l7 + l6) * -4348849565147123417L);
        return CityHashImpl.shiftMix(l9 * -4348849565147123417L + l6) * -7286425919675154353L;
    }

    public static long yandexCityHash64(byte[] byArray, int n, int n2) {
        if (n2 <= 32) {
            if (n2 <= 16) {
                return CityHashImpl.hashLen0to16(byArray, n, n2);
            }
            return CityHashImpl.hashLen17to32(byArray, n, n2);
        }
        if (n2 <= 64) {
            return CityHashImpl.hashLen33to64(byArray, n, n2);
        }
        long l = CityHashImpl.fetch64(byArray, n);
        long l2 = CityHashImpl.fetch64(byArray, n + n2 - 16) ^ 0xB492B66FBE98F273L;
        long l3 = CityHashImpl.fetch64(byArray, n + n2 - 56) ^ 0xC3A5C85C97CB3127L;
        long[] lArray = CityHashImpl.weakHashLen32WithSeeds(byArray, n + n2 - 64, n2, l2);
        long[] lArray2 = CityHashImpl.weakHashLen32WithSeeds(byArray, n + n2 - 32, (long)n2 * -5435081209227447693L, -4348849565147123417L);
        l = CityHashImpl.rotate((l3 += CityHashImpl.shiftMix(lArray[1]) * -5435081209227447693L) + l, 39) * -5435081209227447693L;
        l2 = CityHashImpl.rotate(l2, 33) * -5435081209227447693L;
        n2 = n2 - 1 & 0xFFFFFFC0;
        do {
            l = CityHashImpl.rotate(l + l2 + lArray[0] + CityHashImpl.fetch64(byArray, n + 16), 37) * -5435081209227447693L;
            l2 = CityHashImpl.rotate(l2 + lArray[1] + CityHashImpl.fetch64(byArray, n + 48), 42) * -5435081209227447693L;
            l3 = CityHashImpl.rotate(l3 ^ lArray2[0], 33);
            lArray = CityHashImpl.weakHashLen32WithSeeds(byArray, n + 0, lArray[1] * -5435081209227447693L, (l ^= lArray2[1]) + lArray2[0]);
            lArray2 = CityHashImpl.weakHashLen32WithSeeds(byArray, n + 32, l3 + lArray2[1], l2 ^= lArray[0]);
            long l4 = l3;
            l3 = l;
            l = l4;
            n += 64;
        } while ((n2 -= 64) != 0);
        return CityHashImpl.hashLen16(CityHashImpl.hashLen16(lArray[0], lArray2[0]) + CityHashImpl.shiftMix(l2) * -5435081209227447693L + l3, CityHashImpl.hashLen16(lArray[1], lArray2[1]) + l);
    }

    public static long hashInt(int n, long l) {
        throw new UnsupportedOperationException("CityHash is not implemented for int");
    }

    public static long hashLong(long l, long l2) {
        throw new UnsupportedOperationException("CityHash is not implemented for long");
    }

    public static long hashUnsafeWords(Object object, long l, int n, long l2) {
        throw new UnsupportedOperationException("CityHash is not implemented for unsafe words");
    }

    public static long hashUnsafeBytes(Object object, long l, int n, long l2) {
        return CityHashImpl.yandexCityHash64((byte[])object, (int)l - Platform.BYTE_ARRAY_OFFSET, n);
    }
}

