/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs.eventlog;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogBlock;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogBlock$;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogFileDetails;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.model.EventLogSchema;
import tech.ytsaurus.ysontree.YTreeNode;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0017/\u0001eB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005_\u0001\t\u0015\r\u0011b\u0001`\u0011!1\u0007A!A!\u0002\u0013\u0001\u0007\"B4\u0001\t\u0003A\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007m\u0002\u0001\u000b\u0011\u00029\t\u000f]\u0004!\u0019!C\u0005q\"1Q\u0010\u0001Q\u0001\neDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!A\u0011Q\u0003\u0001!B\u0013\t\t\u0001\u0003\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0000\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0015BA\u0001\u0011)\t\t\u0003\u0001a\u0001\u0002\u0004%I\u0001\u001f\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0003\u0003\u0006\u0002*\u0001\u0001\r\u0011!Q!\neD1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.!Y\u0011Q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001c\u0011-\tY\u0004\u0001a\u0001\u0002\u0003\u0006K!a\f\t\u0015\u0005u\u0002\u00011AA\u0002\u0013%\u0001\u0010C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003BCA#\u0001\u0001\u0007\t\u0011)Q\u0005s\"Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011BA%\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005u\u0003\u00011A\u0001B\u0003&\u00111\n\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001a\u0001\t\u000b\nI\u0007C\u0004\u0002~\u0001!\t%a \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005\"CAI\u0001E\u0005I\u0011BAJ\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!!+\u0001\t\u0003\n)\u0007C\u0004\u0002,\u0002!I!!,\t\u000f\u0005%\u0006\u0001\"\u0011\u0002B\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t\t\u000f\u0001C\u0005\u0003CBq!a9\u0001\t\u0003\n\tGA\fZi\u00163XM\u001c;M_\u001e45/\u00138qkR\u001cFO]3b[*\u0011q\u0006M\u0001\tKZ,g\u000e\u001e7pO*\u0011\u0011GM\u0001\u0003MNT!a\r\u001b\u0002\tM\u0004\u0018\u0010\u001e\u0006\u0003kY\n\u0001\"\u001f;tCV\u0014Xo\u001d\u0006\u0002o\u0005!A/Z2i\u0007\u0001\u0019\"\u0001\u0001\u001e\u0011\u0005m\u001aU\"\u0001\u001f\u000b\u0005Ej$B\u0001 @\u0003\u0019A\u0017\rZ8pa*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!EHA\u0007G'&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0005G>tg\r\u0005\u0002H\u00136\t\u0001J\u0003\u0002F{%\u0011!\n\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003\u001bZs!A\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0005EC\u0014A\u0002\u001fs_>$hHC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)&+\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+S\u0003\u001d!W\r^1jYN\u0004\"a\u0017/\u000e\u00039J!!\u0018\u0018\u0003+e#XI^3oi2{wMR5mK\u0012+G/Y5mg\u0006\u0011\u0011\u0010^\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rN\u0001\u0007G2LWM\u001c;\n\u0005\u0015\u0014'AD\"p[B|WO\u001c3DY&,g\u000e^\u0001\u0004sR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003jU.dW\u000e\u0005\u0002\\\u0001!)QI\u0002a\u0001\r\")1J\u0002a\u0001\u0019\")\u0011L\u0002a\u00015\")aL\u0002a\u0002A\u0006\u0019An\\4\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]!\u0002\u000bMdg\r\u000e6\n\u0005U\u0014(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013aD:j]\u001edWMU3bI2KW.\u001b;\u0016\u0003e\u0004\"A_>\u000e\u0003IK!\u0001 *\u0003\u0007%sG/\u0001\ttS:<G.\u001a*fC\u0012d\u0015.\\5uA\u0005Aa-\u001b8jg\",G-\u0006\u0002\u0002\u0002A\u0019!0a\u0001\n\u0007\u0005\u0015!KA\u0004C_>dW-\u00198\u0002\u0019\u0019Lg.[:iK\u0012|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004u\u00065\u0011bAA\b%\n!QK\\5u\u0011%\t\u0019\u0002DA\u0001\u0002\u0004\t\t!A\u0002yIE\n\u0011BZ5oSNDW\r\u001a\u0011\u0002\u00195\fg.^1m\u00072|7/\u001a3\u0002!5\fg.^1m\u00072|7/\u001a3`I\u0015\fH\u0003BA\u0006\u0003;A\u0011\"a\u0005\u0010\u0003\u0003\u0005\r!!\u0001\u0002\u001b5\fg.^1m\u00072|7/\u001a3!\u0003\u0015y'\u000fZ3s\u0003%y'\u000fZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\u001d\u0002\u0002CA\n%\u0005\u0005\t\u0019A=\u0002\r=\u0014H-\u001a:!\u0003%9Gn\u001c2bYB{7/\u0006\u0002\u00020A\u0019!0!\r\n\u0007\u0005M\"K\u0001\u0003M_:<\u0017!D4m_\n\fG\u000eU8t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005e\u0002\"CA\n+\u0005\u0005\t\u0019AA\u0018\u0003)9Gn\u001c2bYB{7\u000fI\u0001\u0012a>\u001c\u0018J\\\"veJ,g\u000e\u001e\"m_\u000e\\\u0017!\u00069pg&s7)\u001e:sK:$(\t\\8dW~#S-\u001d\u000b\u0005\u0003\u0017\t\u0019\u0005\u0003\u0005\u0002\u0014a\t\t\u00111\u0001z\u0003I\u0001xn]%o\u0007V\u0014(/\u001a8u\u00052|7m\u001b\u0011\u0002\u0019\r,(O]3oi\ncwnY6\u0016\u0005\u0005-\u0003#\u0002>\u0002N\u0005E\u0013bAA(%\n)\u0011I\u001d:bsB\u0019!0a\u0015\n\u0007\u0005U#K\u0001\u0003CsR,\u0017\u0001E2veJ,g\u000e\u001e\"m_\u000e\\w\fJ3r)\u0011\tY!a\u0017\t\u0013\u0005M1$!AA\u0002\u0005-\u0013!D2veJ,g\u000e\u001e\"m_\u000e\\\u0007%\u0001\nsKN,G\u000fV8TiJ,\u0017-\\*uCJ$HCAA\u0006\u0003Y\u0019w.\u001e8u\u0003Z\f\u0017\u000e\\1cY\u0016LeNQ;gM\u0016\u0014H#A=\u0002\tM,Wm\u001b\u000b\u0005\u0003\u0017\tY\u0007C\u0004\u0002n}\u0001\r!a\f\u0002\u0007A|7\u000fK\u0002 \u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0012\u0016AC1o]>$\u0018\r^5p]&!\u00111PA;\u0005\u001d!\u0018-\u001b7sK\u000e\faaZ3u!>\u001cHCAA\u0018\u0003=\u0019X-Z6U_:+woU8ve\u000e,G\u0003BA\u0001\u0003\u000bCq!a\"\"\u0001\u0004\ty#A\u0005uCJ<W\r\u001e)pg\u0006iAn\\1e\u001d\u0016<(\t\\8dWN$B!a\u0003\u0002\u000e\"A\u0011q\u0012\u0012\u0011\u0002\u0003\u0007\u00110A\u0003d_VtG/A\fm_\u0006$g*Z<CY>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0013\u0016\u0004s\u0006]5FAAM!\u0011\tY*!)\u000e\u0005\u0005u%\u0002BAP\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\u0005\r\u0016Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u0002:fC\u0012LHCAA\u0001\u0003\u0011\u0011X-\u00193\u0002\u0011I,\u0017\rZ%na2$\u0012\"_AX\u0003g\u000b9,a/\t\u000f\u0005Ef\u00051\u0001\u0002L\u0005\t!\r\u0003\u0004\u00026\u001a\u0002\r!_\u0001\u0004_\u001a4\u0007BBA]M\u0001\u0007\u00110A\u0002mK:Da!!0'\u0001\u0004I\u0018aA1dG\"\u001aa%!\u001d\u0015\u000fe\f\u0019-!2\u0002H\"9\u0011\u0011W\u0014A\u0002\u0005-\u0003BBA[O\u0001\u0007\u0011\u0010\u0003\u0004\u0002:\u001e\u0002\r!_\u0001\u0005g.L\u0007\u000f\u0006\u0003\u00020\u00055\u0007bBAhQ\u0001\u0007\u0011qF\u0001\u0002]\u0006i1m\u001c9z\u0003Z\f\u0017\u000e\\1cY\u0016$r!_Ak\u0003/\fI\u000eC\u0004\u00022&\u0002\r!a\u0013\t\r\u0005U\u0016\u00061\u0001z\u0011\u0019\tI,\u000ba\u0001s\u00069Qn\u001c<f!>\u001cH\u0003BA\u0006\u0003?Da!a$+\u0001\u0004I\u0018aC2iK\u000e\\7\t\\8tK\u0012\fQa\u00197pg\u0016\u0004")
public class YtEventLogFsInputStream
extends FSInputStream {
    private final String path;
    private final YtEventLogFileDetails details;
    private final CompoundClient yt;
    private final Logger log;
    private final int singleReadLimit;
    private boolean finished;
    private boolean manualClosed;
    private int order;
    private long globalPos;
    private int posInCurrentBlock;
    private byte[] currentBlock;

    public CompoundClient yt() {
        return this.yt;
    }

    private Logger log() {
        return this.log;
    }

    private int singleReadLimit() {
        return this.singleReadLimit;
    }

    private boolean finished() {
        return this.finished;
    }

    private void finished_$eq(boolean x$1) {
        this.finished = x$1;
    }

    private boolean manualClosed() {
        return this.manualClosed;
    }

    private void manualClosed_$eq(boolean x$1) {
        this.manualClosed = x$1;
    }

    private int order() {
        return this.order;
    }

    private void order_$eq(int x$1) {
        this.order = x$1;
    }

    private long globalPos() {
        return this.globalPos;
    }

    private void globalPos_$eq(long x$1) {
        this.globalPos = x$1;
    }

    private int posInCurrentBlock() {
        return this.posInCurrentBlock;
    }

    private void posInCurrentBlock_$eq(int x$1) {
        this.posInCurrentBlock = x$1;
    }

    private byte[] currentBlock() {
        return this.currentBlock;
    }

    private void currentBlock_$eq(byte[] x$1) {
        this.currentBlock = x$1;
    }

    private void resetToStreamStart() {
        this.order_$eq(0);
        this.globalPos_$eq(0L);
        this.posInCurrentBlock_$eq(0);
        this.currentBlock_$eq(new byte[0]);
    }

    private int countAvailableInBuffer() {
        return this.currentBlock().length - this.posInCurrentBlock();
    }

    public final void seek(long pos) {
        block5: {
            BoxedUnit boxedUnit;
            while (true) {
                this.checkClosed();
                if (this.finished()) {
                    return;
                }
                if (pos < 0L) {
                    throw new IllegalArgumentException("Negative seek position");
                }
                if (this.getPos() < pos) {
                    long needRead;
                    int available = this.countAvailableInBuffer();
                    if ((long)available >= (needRead = pos - this.getPos())) {
                        this.movePos((int)needRead);
                        boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    this.movePos(available);
                    long left = needRead - (long)available;
                    long skipBlocksCnt = left / (long)this.details.meta().rowSize();
                    this.order_$eq(this.order() + (int)skipBlocksCnt);
                    this.globalPos_$eq(this.globalPos() + skipBlocksCnt * (long)this.details.meta().rowSize());
                    this.loadNewBlocks(this.loadNewBlocks$default$1());
                    continue;
                }
                if (this.getPos() <= pos) break;
                this.resetToStreamStart();
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public long getPos() {
        return this.globalPos();
    }

    public boolean seekToNewSource(long targetPos) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private void loadNewBlocks(int count) {
        block2: {
            Seq seq;
            try {
                seq = (Seq)YtWrapper$.MODULE$.runWithRetry((Function1 & Serializable & scala.Serializable)transaction -> YtWrapper$.MODULE$.selectRows($this.path, (Option)new Some((Object)new StringBuilder(20).append(EventLogSchema.Key$.MODULE$.ID()).append("=\"").append($this.details.id()).append("\" and ").append(EventLogSchema.Key$.MODULE$.ORDER()).append(" > ").append(this.order()).append(" and ").append(EventLogSchema.Key$.MODULE$.ORDER()).append(" <= ").append(this.order() + count).toString()), (Option)new Some(transaction), YtWrapper$.MODULE$.selectRows$default$4(), this.yt()), YtWrapper$.MODULE$.runWithRetry$default$2(), this.yt());
            }
            catch (Throwable e) {
                this.log().error(new StringBuilder(35).append("Logs(id=").append(EventLogSchema.Key$.MODULE$.ID()).append(", ").append(this.order()).append("<order<=").append(this.order()).append("+").append(count).append(") loading failed").toString(), e);
                seq = (Seq)Nil$.MODULE$;
            }
            Seq rows = seq;
            Seq blocks = (Seq)rows.map((Function1 & Serializable & scala.Serializable)x -> YtEventLogBlock$.MODULE$.apply((YTreeNode)x), Seq$.MODULE$.canBuildFrom());
            this.order_$eq(this.order() + count);
            this.currentBlock_$eq(new byte[BoxesRunTime.unboxToInt((Object)((TraversableOnce)blocks.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)YtEventLogFsInputStream.$anonfun$loadNewBlocks$3(x$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))]);
            blocks.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)YtEventLogFsInputStream.$anonfun$loadNewBlocks$4(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1)));
            this.posInCurrentBlock_$eq(0);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.currentBlock())).isEmpty()) break block2;
            this.finished_$eq(true);
        }
    }

    private int loadNewBlocks$default$1() {
        return 1;
    }

    public boolean ready() {
        return !this.manualClosed() && this.countAvailableInBuffer() > 0;
    }

    public int read() {
        int n;
        this.checkClosed();
        if (this.finished()) {
            return -1;
        }
        if (!this.ready()) {
            this.loadNewBlocks(this.loadNewBlocks$default$1());
        }
        if (this.ready()) {
            this.movePos(1);
            n = this.currentBlock()[this.posInCurrentBlock() - 1];
        } else {
            n = -1;
        }
        return n;
    }

    private int readImpl(byte[] b, int off, int len, int acc) {
        int copied;
        while (true) {
            if (this.finished()) {
                return acc;
            }
            copied = this.copyAvailable(b, off, len);
            if (copied == len) break;
            int newOff = off + copied;
            int newLen = len - copied;
            this.loadNewBlocks(Math.min(this.singleReadLimit() / this.details.meta().rowSize(), newLen / this.details.meta().rowSize() + 1));
            acc += copied;
            len = newLen;
            off = newOff;
        }
        return acc + copied;
    }

    public int read(byte[] b, int off, int len) {
        this.checkClosed();
        int res = this.readImpl(b, off, len, 0);
        return res > 0 ? res : -1;
    }

    public long skip(long n) {
        YtWrapper$.MODULE$.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skip ").append(n).append(" started; details: ").append($this.details).append("; is file finished: ").append(this.finished()).append("; ").append("read blocks: ").append(this.order()).append("; current position: ").append(this.globalPos()).toString());
        if (this.finished() && n > 0L) {
            throw new IOException(new StringBuilder(38).append("Try to skip ").append(n).append(" in ").append(this.details).append(", but data is finished").toString());
        }
        long oldPos = this.getPos();
        this.seek(n + oldPos);
        return this.getPos() - oldPos;
    }

    public int copyAvailable(byte[] b, int off, int len) {
        int willBeCopied = Math.min(this.countAvailableInBuffer(), len);
        System.arraycopy(this.currentBlock(), this.posInCurrentBlock(), b, off, willBeCopied);
        this.movePos(willBeCopied);
        return willBeCopied;
    }

    private void movePos(int count) {
        this.globalPos_$eq(this.globalPos() + (long)count);
        this.posInCurrentBlock_$eq(this.posInCurrentBlock() + count);
    }

    private void checkClosed() {
        if (this.manualClosed()) {
            throw new IOException("Reading from closed stream");
        }
    }

    public void close() {
        YtWrapper$.MODULE$.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Close ").append($this.path).append(", ").append($this.details.fileName()).toString());
        this.finished_$eq(true);
        this.manualClosed_$eq(true);
    }

    public static final /* synthetic */ int $anonfun$loadNewBlocks$3(YtEventLogBlock x$1) {
        return x$1.log().length;
    }

    public static final /* synthetic */ int $anonfun$loadNewBlocks$4(YtEventLogFsInputStream $this, int x0$1, YtEventLogBlock x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int index = tuple2._1$mcI$sp();
        YtEventLogBlock next = (YtEventLogBlock)tuple2._2();
        System.arraycopy(next.log(), 0, $this.currentBlock(), index, next.log().length);
        int n = index + next.log().length;
        return n;
    }

    public YtEventLogFsInputStream(Configuration conf, String path, YtEventLogFileDetails details, CompoundClient yt) {
        this.path = path;
        this.details = details;
        this.yt = yt;
        this.log = LoggerFactory.getLogger((Class)this.getClass());
        this.singleReadLimit = new StringOps(Predef$.MODULE$.augmentString(conf.get("fs.ytEventLog.singleReadLimit", "268435456"))).toInt();
        this.finished = false;
        this.manualClosed = false;
        this.resetToStreamStart();
    }
}

