/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs.eventlog;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.Clock;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.fs.PathUtils$;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogBlock;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogFileDetails;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogFileMeta;
import tech.ytsaurus.spyt.fs.eventlog.YtEventLogFsOutputStream$State$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.config.package$;
import tech.ytsaurus.spyt.wrapper.model.EventLogSchema$;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001\u0002(P\u0001iC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"AQ\u0010\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\tY\u0001\u0001BC\u0002\u0013\r\u0011Q\u0002\u0005\u000b\u00037\u0001!\u0011!Q\u0001\n\u0005=\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"a\u0010\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007Bq!!\u0012\u0001A\u0003%\u0001\u000fC\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u00111\u000b\u0001!\u0002\u0013\tY\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011Q\r\u0001!\u0002\u0013\tIF\u0002\u0004\u0002h\u0001!\u0015\u0011\u000e\u0005\u000b\u0003{\u0002\"Q3A\u0005\u0002\u0005%\u0003BCA@!\tE\t\u0015!\u0003\u0002L!Q\u0011\u0011\u0011\t\u0003\u0016\u0004%\t!!\u0013\t\u0015\u0005\r\u0005C!E!\u0002\u0013\tY\u0005\u0003\u0006\u0002\u0006B\u0011)\u001a!C\u0001\u0003\u000fC!\"a$\u0011\u0005#\u0005\u000b\u0011BAE\u0011)\t\t\n\u0005BK\u0002\u0013\u0005\u0011\u0011\n\u0005\u000b\u0003'\u0003\"\u0011#Q\u0001\n\u0005-\u0003BCAK!\tU\r\u0011\"\u0001\u0002J!Q\u0011q\u0013\t\u0003\u0012\u0003\u0006I!a\u0013\t\u000f\u0005u\u0001\u0003\"\u0001\u0002\u001a\"9\u0011\u0011\u0016\t\u0005\u0002\u0005-\u0006bBAZ!\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003B\u0011AA%\u0011\u001d\t9\f\u0005C\u0001\u0003sC\u0011\"a0\u0011#\u0003%\t!!1\t\u000f\u0005]\u0007\u0003\"\u0001\u0002J!9\u0011\u0011\u001c\t\u0005\u0002\u0005m\u0007\"CAo!\u0005\u0005I\u0011AAp\u0011%\tY\u000fEI\u0001\n\u0003\t\t\rC\u0005\u0002nB\t\n\u0011\"\u0001\u0002B\"I\u0011q\u001e\t\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0003k\u0004\u0012\u0013!C\u0001\u0003\u0003D\u0011\"a>\u0011#\u0003%\t!!1\t\u0013\u0005e\b#!A\u0005B\u0005m\b\"\u0003B\u0004!\u0005\u0005I\u0011AA%\u0011%\u0011I\u0001EA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0018A\t\t\u0011\"\u0011\u0003\u001a!I!q\u0005\t\u0002\u0002\u0013\u0005!\u0011\u0006\u0005\n\u0005[\u0001\u0012\u0011!C!\u0005_A\u0011B!\r\u0011\u0003\u0003%\tEa\r\t\u0013\tU\u0002#!A\u0005B\t]r!\u0003B\u001e\u0001\u0005\u0005\t\u0012\u0002B\u001f\r%\t9\u0007AA\u0001\u0012\u0013\u0011y\u0004C\u0004\u0002\u001eI\"\tA!\u0014\t\u0013\tE\"'!A\u0005F\tM\u0002\"\u0003B(e\u0005\u0005I\u0011\u0011B)\u0011%\u0011iFMA\u0001\n\u0003\u0013y\u0006C\u0005\u0003r\u0001\u0001\r\u0011\"\u0003\u0003t!I!Q\u000f\u0001A\u0002\u0013%!q\u000f\u0005\t\u0005\u0003\u0003\u0001\u0015)\u0003\u0002\u001c\"I!1\u0011\u0001C\u0002\u0013%\u00111\t\u0005\b\u0005\u000b\u0003\u0001\u0015!\u0003q\u0011%\u00119\t\u0001a\u0001\n\u0013\tY\u000eC\u0005\u0003\n\u0002\u0001\r\u0011\"\u0003\u0003\f\"A!q\u0012\u0001!B\u0013\ti\u000bC\u0004\u0003\u0012\u0002!\tAa%\t\u000f\tU\u0005\u0001\"\u0011\u0003\u0018\"9!Q\u0013\u0001\u0005B\tu\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005W\u0003A\u0011\u0002B^\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000fDqAa5\u0001\t\u0013\u0011)\u000eC\u0004\u0003\\\u0002!IA!8\t\u000f\t\u0005\b\u0001\"\u0003\u0003d\"9!Q\u001f\u0001\u0005\n\t]\b\"\u0003B\u007f\u0001E\u0005I\u0011\u0002B\u0000\u0011\u001d\u0019\u0019\u0001\u0001C!\u0005'Cqa!\u0002\u0001\t\u0013\u00199\u0001C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0003\u0004\u0012!91Q\u0003\u0001\u0005B\tM%\u0001G-u\u000bZ,g\u000e\u001e'pO\u001a\u001bx*\u001e;qkR\u001cFO]3b[*\u0011\u0001+U\u0001\tKZ,g\u000e\u001e7pO*\u0011!kU\u0001\u0003MNT!\u0001V+\u0002\tM\u0004\u0018\u0010\u001e\u0006\u0003-^\u000b\u0001\"\u001f;tCV\u0014Xo\u001d\u0006\u00021\u0006!A/Z2i\u0007\u0001\u0019\"\u0001A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016AA5p\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\t\r|gN\u001a\t\u0003K6l\u0011A\u001a\u0006\u0003G\u001eT!\u0001[5\u0002\r!\fGm\\8q\u0015\tQ7.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0006\u0019qN]4\n\u000594'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0003qCRD\u0007CA9{\u001d\t\u0011\b\u0010\u0005\u0002tm6\tAO\u0003\u0002v3\u00061AH]8pizR\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\fa\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011P^\u0001\tM&dWMT1nK\u0006)1\r\\8dWB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006}\u000bA\u0001^5nK&!\u0011\u0011BA\u0002\u0005\u0015\u0019En\\2l\u0003\tIH/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016U\u000baa\u00197jK:$\u0018\u0002BA\r\u0003'\u0011abQ8na>,h\u000eZ\"mS\u0016tG/A\u0002zi\u0002\na\u0001P5oSRtD\u0003DA\u0011\u0003K\t9#!\u000b\u0002,\u00055\u0002cAA\u0012\u00015\tq\nC\u0003d\u000f\u0001\u0007A\rC\u0003p\u000f\u0001\u0007\u0001\u000fC\u0003~\u000f\u0001\u0007\u0001\u000fC\u0003\u007f\u000f\u0001\u0007q\u0010C\u0004\u0002\f\u001d\u0001\u001d!a\u0004\u0002\u00071|w-\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:-\fQa\u001d7gi)LA!!\u0010\u00028\t1Aj\\4hKJ\fA\u0001\\8hA\u0005AQ.\u001a;b!\u0006$\b.F\u0001q\u0003%iW\r^1QCRD\u0007%A\u0004s_^\u001c\u0016N_3\u0016\u0005\u0005-\u0003\u0003BA'\u0003\u001fj\u0011A^\u0005\u0004\u0003#2(aA%oi\u0006A!o\\<TSj,\u0007%\u0001\u0004ck\u001a4WM]\u000b\u0003\u00033\u0002b!!\u0014\u0002\\\u0005}\u0013bAA/m\n)\u0011I\u001d:bsB!\u0011QJA1\u0013\r\t\u0019G\u001e\u0002\u0005\u0005f$X-A\u0004ck\u001a4WM\u001d\u0011\u0003\u000bM#\u0018\r^3\u0014\u000fA\tY'!\u001d\u0002xA!\u0011QJA7\u0013\r\tyG\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\t\u00055\u00131O\u0005\u0004\u0003k2(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u001b\nI(C\u0002\u0002|Y\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011BY;gM\u0016\u0014\bk\\:\u0002\u0015\t,hMZ3s!>\u001c\b%\u0001\u0007mCN$h\t\\;tQB{7/A\u0007mCN$h\t\\;tQB{7\u000fI\u0001\u0010M2,8\u000f[3e\t\u0006$\u0018mU5{KV\u0011\u0011\u0011\u0012\t\u0005\u0003\u001b\nY)C\u0002\u0002\u000eZ\u0014A\u0001T8oO\u0006\u0001b\r\\;tQ\u0016$G)\u0019;b'&TX\rI\u0001\u000bE2|7m[\"pk:$\u0018a\u00032m_\u000e\\7i\\;oi\u0002\n\u0001C\u00197pG.,\u0006\u000fZ1uK\u000e{WO\u001c;\u0002#\tdwnY6Va\u0012\fG/Z\"pk:$\b\u0005\u0006\u0007\u0002\u001c\u0006}\u0015\u0011UAR\u0003K\u000b9\u000bE\u0002\u0002\u001eBi\u0011\u0001\u0001\u0005\b\u0003{Z\u0002\u0019AA&\u0011\u001d\t\ti\u0007a\u0001\u0003\u0017Bq!!\"\u001c\u0001\u0004\tI\tC\u0004\u0002\u0012n\u0001\r!a\u0013\t\u000f\u0005U5\u00041\u0001\u0002L\u0005\u00112-\u001e:sK:$(\t\\8dW&\u001bh)\u001e7m)\t\ti\u000b\u0005\u0003\u0002N\u0005=\u0016bAAYm\n9!i\\8mK\u0006t\u0017a\u00059sKZ4E.^:i/\u0006\u001c\b+\u0019:uS\u0006d\u0017!\u00058fqR\u0014En\\2l'R\f'\u000f\u001e)pg\u0006a\u0011N\\2Ck\u001a4WM\u001d)pgR!\u00111TA^\u0011%\til\bI\u0001\u0002\u0004\tY%\u0001\u0004mK:<G\u000f[\u0001\u0017S:\u001c')\u001e4gKJ\u0004vn\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0019\u0016\u0005\u0003\u0017\n)m\u000b\u0002\u0002HB!\u0011\u0011ZAj\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017!C;oG\",7m[3e\u0015\r\t\tN^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAk\u0003\u0017\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-qWm\u001e#bi\u0006\u001c\u0016N_3\u0002\u0015!\f7OT3x\t\u0006$\u0018-\u0006\u0002\u0002.\u0006!1m\u001c9z)1\tY*!9\u0002d\u0006\u0015\u0018q]Au\u0011%\tih\tI\u0001\u0002\u0004\tY\u0005C\u0005\u0002\u0002\u000e\u0002\n\u00111\u0001\u0002L!I\u0011QQ\u0012\u0011\u0002\u0003\u0007\u0011\u0011\u0012\u0005\n\u0003#\u001b\u0003\u0013!a\u0001\u0003\u0017B\u0011\"!&$!\u0003\u0005\r!a\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%c\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003gTC!!#\u0002F\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\b\u0003BA\u0000\u0005\u000bi!A!\u0001\u000b\u0007\t\rq,\u0001\u0003mC:<\u0017bA>\u0003\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0007\u0005'\u0001B!!\u0014\u0003\u0010%\u0019!\u0011\u0003<\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u0016-\n\t\u00111\u0001\u0002L\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0007\u0011\r\tu!1\u0005B\u0007\u001b\t\u0011yBC\u0002\u0003\"Y\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ca\b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003[\u0013Y\u0003C\u0005\u0003\u00165\n\t\u00111\u0001\u0003\u000e\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002L\u0005AAo\\*ue&tw\r\u0006\u0002\u0002~\u00061Q-];bYN$B!!,\u0003:!I!Q\u0003\u0019\u0002\u0002\u0003\u0007!QB\u0001\u0006'R\fG/\u001a\t\u0004\u0003;\u00134#\u0002\u001a\u0003B\u0005]\u0004\u0003\u0005B\"\u0005\u0013\nY%a\u0013\u0002\n\u0006-\u00131JAN\u001b\t\u0011)EC\u0002\u0003HY\fqA];oi&lW-\u0003\u0003\u0003L\t\u0015#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okQ\u0011!QH\u0001\u0006CB\u0004H.\u001f\u000b\r\u00037\u0013\u0019F!\u0016\u0003X\te#1\f\u0005\b\u0003{*\u0004\u0019AA&\u0011\u001d\t\t)\u000ea\u0001\u0003\u0017Bq!!\"6\u0001\u0004\tI\tC\u0004\u0002\u0012V\u0002\r!a\u0013\t\u000f\u0005UU\u00071\u0001\u0002L\u00059QO\\1qa2LH\u0003\u0002B1\u0005[\u0002b!!\u0014\u0003d\t\u001d\u0014b\u0001B3m\n1q\n\u001d;j_:\u0004b\"!\u0014\u0003j\u0005-\u00131JAE\u0003\u0017\nY%C\u0002\u0003lY\u0014a\u0001V;qY\u0016,\u0004\"\u0003B8m\u0005\u0005\t\u0019AAN\u0003\rAH\u0005M\u0001\u0006gR\fG/Z\u000b\u0003\u00037\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\t\te$q\u0010\t\u0005\u0003\u001b\u0012Y(C\u0002\u0003~Y\u0014A!\u00168ji\"I!Q\u0003\u001d\u0002\u0002\u0003\u0007\u00111T\u0001\u0007gR\fG/\u001a\u0011\u0002\u0005%$\u0017aA5eA\u000591\u000f^1si\u0016$\u0017aC:uCJ$X\rZ0%KF$BA!\u001f\u0003\u000e\"I!QC\u001f\u0002\u0002\u0003\u0007\u0011QV\u0001\tgR\f'\u000f^3eA\u0005!q\u000e]3o)\t\u0011I(A\u0003xe&$X\r\u0006\u0003\u0003z\te\u0005b\u0002BN\u0001\u0002\u0007\u00111J\u0001\u0002ERA!\u0011\u0010BP\u0005G\u00139\u000bC\u0004\u0003\"\u0006\u0003\r!!\u0017\u0002\u000b\u00154XM\u001c;\t\u000f\t\u0015\u0016\t1\u0001\u0002L\u0005\u0019qN\u001a4\t\u000f\t%\u0016\t1\u0001\u0002L\u0005\u0019A.\u001a8\u0002\u0013]\u0014\u0018\u000e^3J[BdG\u0003\u0002B=\u0005_CqAa'C\u0001\u0004\tY\u0005K\u0002C\u0005g\u0003BA!.\u000386\u0011\u0011qZ\u0005\u0005\u0005s\u000byMA\u0004uC&d'/Z2\u0015\u0011\te$Q\u0018B`\u0005\u0003DqA!)D\u0001\u0004\tI\u0006C\u0004\u0003&\u000e\u0003\r!a\u0013\t\u000f\t%6\t1\u0001\u0002L!\u001a1Ia-\u0002-Q\u0014\u0018pV5uQ\u000e{gn]5ti\u0016tGo\u0015;bi\u0016$BA!\u001f\u0003J\"A!1\u001a#\u0005\u0002\u0004\u0011i-A\u0001g!\u0019\tiEa4\u0003z%\u0019!\u0011\u001b<\u0003\u0011q\u0012\u0017P\\1nKz\nQb\u001e:ji\u0016tUm\u001e\"m_\u000e\\G\u0003BAW\u0005/DqA!7F\u0001\u0004\tI&\u0001\u0003eCR\f\u0017aC;qI\u0006$XM\u00117pG.$B!!,\u0003`\"9!\u0011\u001c$A\u0002\u0005e\u0013aD;qI\u0006$XmV5uQJ+GO]=\u0015\t\te$Q\u001d\u0005\b\u0005O<\u0005\u0019\u0001Bu\u0003\u0011\u0019w\u000eZ3\u0011\u0011\u00055#1\u001eBx\u0005sJ1A!<w\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0012\tE\u0018\u0002\u0002Bz\u0003'\u0011Q#\u00119j'\u0016\u0014h/[2f)J\fgn]1di&|g.A\u0005gYV\u001c\b.S7qYR!\u0011Q\u0016B}\u0011%\u0011Y\u0010\u0013I\u0001\u0002\u0004\ti+\u0001\u0004g_J\u001cW\rZ\u0001\u0014M2,8\u000f[%na2$C-\u001a4bk2$H%M\u000b\u0003\u0007\u0003QC!!,\u0002F\u0006)a\r\\;tQ\u0006QQ\u000f\u001d3bi\u0016LeNZ8\u0015\t\te4\u0011\u0002\u0005\n\u0007\u0017Y\u0005\u0013!a\u0001\u0007\u001b\t1\u0002\u001e:b]N\f7\r^5p]B1\u0011Q\nB2\u0005_\fA#\u001e9eCR,\u0017J\u001c4pI\u0011,g-Y;mi\u0012\nTCAB\nU\u0011\u0019i!!2\u0002\u000b\rdwn]3")
public class YtEventLogFsOutputStream
extends OutputStream {
    private volatile YtEventLogFsOutputStream$State$ State$module;
    private final Configuration conf;
    private final String path;
    private final String fileName;
    private final Clock clock;
    private final CompoundClient yt;
    private final Logger log;
    private final String metaPath;
    private final int tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize;
    private final byte[] buffer;
    private State state;
    private final String id;
    private boolean started;

    private YtEventLogFsOutputStream$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public CompoundClient yt() {
        return this.yt;
    }

    private Logger log() {
        return this.log;
    }

    private String metaPath() {
        return this.metaPath;
    }

    public int tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize() {
        return this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize;
    }

    private byte[] buffer() {
        return this.buffer;
    }

    private State state() {
        return this.state;
    }

    private void state_$eq(State x$1) {
        this.state = x$1;
    }

    private String id() {
        return this.id;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public void open() {
        try {
            Map extraTableOpts = package$.MODULE$.SparkYtHadoopConfiguration(this.conf).getConfWithPrefix("eventLog.extraTableOpts");
            YtWrapper$.MODULE$.createDynTableAndMount(this.path, EventLogSchema$.MODULE$.schema(), extraTableOpts, YtWrapper$.MODULE$.createDynTableAndMount$default$4(), this.yt());
            YtWrapper$.MODULE$.createDynTableAndMount(this.metaPath(), EventLogSchema$.MODULE$.metaSchema(), extraTableOpts, YtWrapper$.MODULE$.createDynTableAndMount$default$4(), this.yt());
            YtWrapper$.MODULE$.runWithRetry((Function1 & Serializable & scala.Serializable)transaction -> {
                this.updateInfo((Option<ApiServiceTransaction>)new Some((Object)transaction));
                return BoxedUnit.UNIT;
            }, YtWrapper$.MODULE$.runWithRetry$default$2(), this.yt());
            this.started_$eq(true);
        }
        catch (Throwable e) {
            this.log().error("Initialization failed, all logs will be lost", e);
        }
    }

    @Override
    public void write(int b) {
        block0: {
            if (!this.started()) break block0;
            this.writeImpl(b);
        }
    }

    @Override
    public void write(byte[] event, int off, int len) {
        block0: {
            if (!this.started()) break block0;
            this.writeImpl(event, off, len);
        }
    }

    private void writeImpl(int b) {
        block1: {
            BoxedUnit boxedUnit;
            while (this.state().currentBlockIsFull()) {
                if (this.flushImpl(this.flushImpl$default$1())) continue;
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            }
            this.buffer()[this.state().bufferPos()] = (byte)b;
            State qual$1 = this.state();
            int x$1 = qual$1.incBufferPos$default$1();
            this.state_$eq(qual$1.incBufferPos(x$1));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void writeImpl(byte[] event, int off, int len) {
        block2: {
            BoxedUnit boxedUnit;
            block1: {
                while (true) {
                    int free = this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize() - this.state().bufferPos();
                    int copyLen = Math.min(free, len);
                    System.arraycopy(event, off, this.buffer(), this.state().bufferPos(), copyLen);
                    this.state_$eq(this.state().incBufferPos(copyLen));
                    if (free >= len) break block1;
                    if (!this.flushImpl(this.flushImpl$default$1())) break;
                    len -= free;
                    off += free;
                }
                boxedUnit = BoxedUnit.UNIT;
                break block2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void tryWithConsistentState(Function0<BoxedUnit> f) {
        State prevState = this.state();
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable e) {
            this.log().error(new StringBuilder(46).append("Error while uploading logs with id=").append(this.id()).append(" and order=").append(this.state().blockCount()).toString(), e);
            this.state_$eq(prevState);
        }
    }

    private boolean writeNewBlock(byte[] data) {
        BooleanRef success = BooleanRef.create((boolean)false);
        this.tryWithConsistentState((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.state_$eq(new State(this, this.state().nextBlockStartPos(), this.state().bufferPos(), this.state().flushedDataSize() + (long)this.state().newDataSize(), this.state().blockCount() + 1, 0));
            this.updateWithRetry((Function1<ApiServiceTransaction, BoxedUnit>)(Function1 & Serializable & scala.Serializable)transaction -> {
                YtWrapper$.MODULE$.insertRows(this.path, EventLogSchema$.MODULE$.schema(), (Seq)new .colon.colon(new YtEventLogBlock(this.id(), this.state().blockCount(), data).toList(), (List)Nil$.MODULE$), (Option)new Some((Object)transaction), this.yt());
                return BoxedUnit.UNIT;
            });
            success$1.elem = true;
        });
        return success.elem;
    }

    private boolean updateBlock(byte[] data) {
        BooleanRef success = BooleanRef.create((boolean)false);
        this.tryWithConsistentState((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.state_$eq(new State(this, this.state().nextBlockStartPos(), this.state().bufferPos(), this.state().flushedDataSize() + (long)this.state().newDataSize(), this.state().blockCount(), this.state().blockUpdateCount() + 1));
            this.updateWithRetry((Function1<ApiServiceTransaction, BoxedUnit>)(Function1 & Serializable & scala.Serializable)transaction -> {
                YtWrapper$.MODULE$.updateRow(this.path, EventLogSchema$.MODULE$.schema(), new YtEventLogBlock(this.id(), this.state().blockCount(), data).toJavaMap(), (Option)new Some((Object)transaction), this.yt());
                return BoxedUnit.UNIT;
            });
            success$2.elem = true;
        });
        return success.elem;
    }

    private void updateWithRetry(Function1<ApiServiceTransaction, BoxedUnit> code) {
        block0: {
            IntRef tryCount = IntRef.create((int)0);
            YtWrapper$.MODULE$.runWithRetry((Function1 & Serializable & scala.Serializable)transaction -> {
                YtEventLogFsOutputStream.$anonfun$updateWithRetry$1(this, tryCount, code, transaction);
                return BoxedUnit.UNIT;
            }, YtWrapper$.MODULE$.runWithRetry$default$2(), this.yt());
            if (tryCount.elem <= 1) break block0;
            this.log().info(new StringBuilder(44).append("UUID: ").append(this.id()).append(" (filename: ").append(this.fileName).append(") was updated using ").append(tryCount.elem).append(" tries").toString());
        }
    }

    private boolean flushImpl(boolean forced) {
        boolean bl;
        if (this.state().hasNewData()) {
            byte[] data;
            byte[] byArray = data = this.state().currentBlockIsFull() ? this.buffer() : (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.buffer())).slice(0, this.state().bufferPos());
            bl = this.state().prevFlushWasPartial() ? (this.state().blockUpdateCount() < 3 || forced || this.state().currentBlockIsFull() ? this.updateBlock(data) : false) : this.writeNewBlock(data);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void flush() {
        block0: {
            if (!this.started()) break block0;
            this.flushImpl(this.flushImpl$default$1());
        }
    }

    private boolean flushImpl$default$1() {
        return false;
    }

    private void updateInfo(Option<ApiServiceTransaction> transaction) {
        YtWrapper$.MODULE$.updateRow(this.metaPath(), EventLogSchema$.MODULE$.metaSchema(), new YtEventLogFileDetails(this.fileName, this.id(), new YtEventLogFileMeta(this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize(), this.state().blockCount(), this.state().flushedDataSize(), this.clock.millis())).toJavaMap(), transaction, this.yt());
    }

    private Option<ApiServiceTransaction> updateInfo$default$1() {
        return None$.MODULE$;
    }

    @Override
    public void close() {
        block0: {
            if (!this.started()) break block0;
            this.flushImpl(true);
        }
    }

    private final void State$lzycompute$1() {
        YtEventLogFsOutputStream ytEventLogFsOutputStream = this;
        synchronized (ytEventLogFsOutputStream) {
            if (this.State$module == null) {
                this.State$module = new YtEventLogFsOutputStream$State$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$updateWithRetry$1(YtEventLogFsOutputStream $this, IntRef tryCount$1, Function1 code$1, ApiServiceTransaction transaction) {
        ++tryCount$1.elem;
        code$1.apply((Object)transaction);
        $this.updateInfo((Option<ApiServiceTransaction>)new Some((Object)transaction));
    }

    public YtEventLogFsOutputStream(Configuration conf, String path, String fileName, Clock clock, CompoundClient yt) {
        this.conf = conf;
        this.path = path;
        this.fileName = fileName;
        this.clock = clock;
        this.yt = yt;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.metaPath = PathUtils$.MODULE$.getMetaPath(path);
        this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize = new StringOps(Predef$.MODULE$.augmentString(conf.get("yt.dynTable.rowSize", "16777216"))).toInt();
        this.buffer = new byte[this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize()];
        this.state = new State(this, 0, this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize(), 0L, 0, 0);
        this.id = String.valueOf(UUID.randomUUID());
        this.started = false;
        this.open();
    }

    private class State
    implements Product,
    scala.Serializable {
        private final int bufferPos;
        private final int lastFlushPos;
        private final long flushedDataSize;
        private final int blockCount;
        private final int blockUpdateCount;
        public final /* synthetic */ YtEventLogFsOutputStream $outer;

        public int bufferPos() {
            return this.bufferPos;
        }

        public int lastFlushPos() {
            return this.lastFlushPos;
        }

        public long flushedDataSize() {
            return this.flushedDataSize;
        }

        public int blockCount() {
            return this.blockCount;
        }

        public int blockUpdateCount() {
            return this.blockUpdateCount;
        }

        public boolean currentBlockIsFull() {
            return this.bufferPos() == this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer().tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize();
        }

        public boolean prevFlushWasPartial() {
            return this.lastFlushPos() < this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer().tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize();
        }

        public int nextBlockStartPos() {
            return this.currentBlockIsFull() ? 0 : this.bufferPos();
        }

        public State incBufferPos(int length) {
            return this.copy(this.bufferPos() + length, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public int incBufferPos$default$1() {
            return 1;
        }

        public int newDataSize() {
            int dataStartPos = this.lastFlushPos() < this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer().tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$$rowSize() ? this.lastFlushPos() : 0;
            return this.bufferPos() - dataStartPos;
        }

        public boolean hasNewData() {
            return this.newDataSize() > 0;
        }

        public State copy(int bufferPos, int lastFlushPos, long flushedDataSize, int blockCount, int blockUpdateCount) {
            return new State(this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer(), bufferPos, lastFlushPos, flushedDataSize, blockCount, blockUpdateCount);
        }

        public int copy$default$1() {
            return this.bufferPos();
        }

        public int copy$default$2() {
            return this.lastFlushPos();
        }

        public long copy$default$3() {
            return this.flushedDataSize();
        }

        public int copy$default$4() {
            return this.blockCount();
        }

        public int copy$default$5() {
            return this.blockUpdateCount();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                case 0: {
                    number = BoxesRunTime.boxToInteger((int)this.bufferPos());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.lastFlushPos());
                    break;
                }
                case 2: {
                    number = BoxesRunTime.boxToLong((long)this.flushedDataSize());
                    break;
                }
                case 3: {
                    number = BoxesRunTime.boxToInteger((int)this.blockCount());
                    break;
                }
                case 4: {
                    number = BoxesRunTime.boxToInteger((int)this.blockUpdateCount());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.bufferPos());
            n = Statics.mix((int)n, (int)this.lastFlushPos());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.flushedDataSize()));
            n = Statics.mix((int)n, (int)this.blockCount());
            n = Statics.mix((int)n, (int)this.blockUpdateCount());
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer() != this.tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            if (this.bufferPos() != state.bufferPos()) return false;
            if (this.lastFlushPos() != state.lastFlushPos()) return false;
            if (this.flushedDataSize() != state.flushedDataSize()) return false;
            if (this.blockCount() != state.blockCount()) return false;
            if (this.blockUpdateCount() != state.blockUpdateCount()) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ YtEventLogFsOutputStream tech$ytsaurus$spyt$fs$eventlog$YtEventLogFsOutputStream$State$$$outer() {
            return this.$outer;
        }

        public State(YtEventLogFsOutputStream $outer, int bufferPos, int lastFlushPos, long flushedDataSize, int blockCount, int blockUpdateCount) {
            this.bufferPos = bufferPos;
            this.lastFlushPos = lastFlushPos;
            this.flushedDataSize = flushedDataSize;
            this.blockCount = blockCount;
            this.blockUpdateCount = blockUpdateCount;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

