/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.YsonBinaryWriter;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

public class YTreeBinarySerializer {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    protected YTreeBinarySerializer() {
    }

    public static ClosableYsonConsumer getSerializer(OutputStream output) {
        return YTreeBinarySerializer.getSerializer(output, 4096);
    }

    public static ClosableYsonConsumer getSerializer(OutputStream output, int bufferSize) {
        return new YsonBinaryWriter(output, bufferSize){

            public void close() {
                super.flush();
            }
        };
    }

    public static void serialize(YTreeNode node, OutputStream output) {
        ClosableYsonConsumer writer = YTreeBinarySerializer.getSerializer(output);
        YTreeNodeUtils.walk(node, (YsonConsumer)writer, true);
        writer.close();
    }

    public static InputStream serializeAndGet(YTreeNode node) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize(node, baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static YTreeNode deserialize(InputStream input) {
        return YTreeBinarySerializer.deserialize(input, new byte[4096]);
    }

    public static YTreeNode deserialize(InputStream input, byte[] buffer) {
        YTreeBuilder builder = YTree.builder();
        YsonParser parser = new YsonParser(input, buffer);
        parser.parseNode((YsonConsumer)builder);
        return builder.build();
    }

    public static void deserialize(InputStream input, YsonConsumer consumer) {
        YsonParser parser = new YsonParser(input, 4096);
        parser.parseNode(consumer);
    }

    public static List<YTreeNode> deserializeAll(InputStream input) {
        return YTreeBinarySerializer.deserializeAll(input, new byte[4096]);
    }

    public static List<YTreeNode> deserializeAll(InputStream input, byte[] buffer) {
        YTreeBuilder builder = YTree.builder().beginList();
        YsonParser parser = new YsonParser(input, buffer);
        while (parser.parseListFragmentItem((YsonConsumer)builder)) {
        }
        return builder.buildList().asList();
    }
}

