/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.util.List;
import java.util.Map;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeCompositeNode;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

public interface YTreeListNode
extends YTreeCompositeNode<YTreeNode> {
    public YTreeNode get(int var1);

    public YTreeNode set(int var1, YTreeNode var2);

    public YTreeNode remove(int var1);

    public void add(YTreeNode var1);

    default public void addAll(List<YTreeNode> values) {
        values.forEach(this::add);
    }

    default public String getString(int index) {
        return this.get(index).stringValue();
    }

    default public byte[] getBytes(int index) {
        return this.get(index).bytesValue();
    }

    default public int getInt(int index) {
        return this.get(index).intValue();
    }

    default public long getLong(int index) {
        return this.get(index).longValue();
    }

    default public boolean getBool(int index) {
        return this.get(index).boolValue();
    }

    default public double getDouble(int index) {
        return this.get(index).doubleValue();
    }

    default public YTreeListNode getList(int index) {
        return this.get(index).listNode();
    }

    default public YTreeMapNode getMap(int index) {
        return this.get(index).mapNode();
    }

    default public YTreeBuilder toListBuilder() {
        YTreeBuilder builder = YTree.builder();
        Map<String, YTreeNode> attributes = this.getAttributes();
        if (!attributes.isEmpty()) {
            builder.beginAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                builder.key((String)entry.getKey()).value((YTreeNode)entry.getValue());
            }
            builder.endAttributes();
        }
        builder.beginList();
        for (YTreeNode yTreeNode : this.asList()) {
            builder.value(yTreeNode);
        }
        return builder;
    }
}

