/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeCompositeNode;
import tech.ytsaurus.ysontree.YTreeListNode;
import tech.ytsaurus.ysontree.YTreeNode;

public interface YTreeMapNode
extends YTreeCompositeNode<Map.Entry<String, YTreeNode>> {
    public Set<String> keys();

    public Collection<YTreeNode> values();

    public boolean containsKey(String var1);

    public Optional<YTreeNode> remove(String var1);

    public Optional<YTreeNode> put(String var1, YTreeNode var2);

    public void putAll(Map<? extends String, ? extends YTreeNode> var1);

    public Optional<YTreeNode> get(String var1);

    default public YTreeNode getOrThrow(String key) {
        return this.getOrThrow(key, () -> "Key not found: " + key);
    }

    default public YTreeNode getOrThrow(String key, Supplier<String> createMessage) {
        return this.get(key).orElseThrow(() -> new NoSuchElementException((String)createMessage.get()));
    }

    default public YTreeNode getOrDefault(String key, Supplier<YTreeNode> defaultNode) {
        return this.get(key).orElseGet(defaultNode);
    }

    default public String getString(String key) {
        return this.getOrThrow(key).stringValue();
    }

    default public Optional<String> getStringO(String key) {
        return this.getFilterNull(key).map(YTreeNode::stringValue);
    }

    default public byte[] getBytes(String key) {
        return this.getOrThrow(key).bytesValue();
    }

    default public Optional<byte[]> getBytesO(String key) {
        return this.getFilterNull(key).map(YTreeNode::bytesValue);
    }

    default public int getInt(String key) {
        return this.getOrThrow(key).intValue();
    }

    default public Optional<Integer> getIntO(String key) {
        return this.getFilterNull(key).map(YTreeNode::intValue);
    }

    default public long getLong(String key) {
        return this.getOrThrow(key).longValue();
    }

    default public Optional<Long> getLongO(String key) {
        return this.getFilterNull(key).map(YTreeNode::longValue);
    }

    default public boolean getBool(String key) {
        return this.getOrThrow(key).boolValue();
    }

    default public Optional<Boolean> getBoolO(String key) {
        return this.getFilterNull(key).map(YTreeNode::boolValue);
    }

    default public double getDouble(String key) {
        return this.getOrThrow(key).doubleValue();
    }

    default public Optional<Double> getDoubleO(String key) {
        return this.getFilterNull(key).map(YTreeNode::doubleValue);
    }

    default public YTreeListNode getList(String key) {
        return this.getOrThrow(key).listNode();
    }

    default public Optional<YTreeListNode> getListO(String key) {
        return this.getFilterNull(key).map(YTreeNode::listNode);
    }

    default public YTreeMapNode getMap(String key) {
        return this.getOrThrow(key).mapNode();
    }

    default public Optional<YTreeMapNode> getMapO(String key) {
        return this.getFilterNull(key).map(YTreeNode::mapNode);
    }

    default public Optional<YTreeNode> getFilterNull(String key) {
        return this.get(key).filter(node -> !node.isEntityNode());
    }

    default public YTreeBuilder toMapBuilder() {
        YTreeBuilder builder = YTree.builder();
        Map<String, YTreeNode> attributes = this.getAttributes();
        if (!attributes.isEmpty()) {
            builder.beginAttributes();
            for (Map.Entry<String, YTreeNode> entry : attributes.entrySet()) {
                builder.key(entry.getKey()).value(entry.getValue());
            }
            builder.endAttributes();
        }
        builder.beginMap();
        for (Map.Entry<String, YTreeNode> entry : this.asMap().entrySet()) {
            builder.key(entry.getKey()).value(entry.getValue());
        }
        return builder;
    }
}

