/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeTextSerializer;

public abstract class YTreeNodeImpl
implements YTreeNode {
    private Map<String, YTreeNode> attributes;

    public YTreeNodeImpl(@Nullable Map<String, YTreeNode> attributes) {
        this.attributes = attributes == null ? null : new HashMap<String, YTreeNode>(attributes);
    }

    @Override
    public Map<String, YTreeNode> getAttributes() {
        this.init();
        return this.attributes;
    }

    @Override
    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    @Override
    public boolean containsAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    @Override
    public boolean containsAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    @Override
    public Optional<YTreeNode> removeAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.remove(key));
    }

    @Override
    public Optional<YTreeNode> putAttribute(String key, YTreeNode value) {
        this.init();
        return Optional.ofNullable(this.attributes.put(key, value));
    }

    @Override
    public Optional<YTreeNode> getAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.get(key));
    }

    @Override
    public YTreeNode getAttributeOrThrow(String key) {
        if (this.attributes == null || !this.attributes.containsKey(key)) {
            throw new NoSuchElementException("Key " + key);
        }
        return this.attributes.get(key);
    }

    @Override
    public YTreeNode getAttributeOrThrow(String key, Supplier<String> createMessage) {
        if (this.attributes == null || !this.attributes.containsKey(key)) {
            throw new NoSuchElementException(createMessage.get());
        }
        return this.attributes.get(key);
    }

    public String toString() {
        return YTreeTextSerializer.serialize(this);
    }

    @Override
    public byte[] toBinary() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize(this, output);
        return output.toByteArray();
    }

    protected int hashCodeBase() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.hashCode();
    }

    protected boolean equalsBase(YTreeNode another0) {
        YTreeNodeImpl another = (YTreeNodeImpl)another0;
        if (this.attributes == null) {
            return another.attributes == null || another.attributes.isEmpty();
        }
        if (another.attributes == null) {
            return this.attributes.isEmpty();
        }
        return this.attributes.equals(another.attributes);
    }

    private void init() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, YTreeNode>();
        }
    }
}

