/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class DecimalType
extends TiType {
    public static final int MAX_PRECISION = 35;
    final int precision;
    final int scale;

    public DecimalType(int precision, int scale) {
        super(TypeName.Decimal);
        if (precision <= 0 || precision > 35) {
            throw new RuntimeException(String.format("TODO: precision must be in range [1, %d]", 35));
        }
        if (scale < 0 || scale > 35) {
            throw new RuntimeException(String.format("TODO: scale must be in range [0, precision (=%d)]", precision));
        }
        this.precision = precision;
        this.scale = scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d, %d)", this.precision, this.scale);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.typeName, this.precision, this.scale});
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Decimal.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Decimal.wireNameBytes);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.PRECISION);
        ysonConsumer.onInteger((long)this.precision);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.SCALE);
        ysonConsumer.onInteger((long)this.scale);
        ysonConsumer.onEndMap();
    }
}

