/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.Escape;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class TaggedType
extends TiType {
    final TiType item;
    final String tag;

    TaggedType(TiType item, String tag) {
        super(TypeName.Tagged);
        this.item = item;
        this.tag = tag;
    }

    public TiType getItem() {
        return this.item;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String toString() {
        return String.format("Tagged<%s, %s>", this.item, Escape.quote(this.tag));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TaggedType that = (TaggedType)o;
        return this.tag.equals(that.tag) && this.item.equals(that.item);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{TypeName.Tagged, this.item, this.tag});
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Tagged.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Tagged.wireNameBytes);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.ITEM);
        this.item.serializeTo(ysonConsumer);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TAG);
        ysonConsumer.onString(this.tag);
        ysonConsumer.onEndMap();
    }
}

