/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.List;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.DecimalType;
import tech.ytsaurus.typeinfo.DictType;
import tech.ytsaurus.typeinfo.ListType;
import tech.ytsaurus.typeinfo.NonParametrizedType;
import tech.ytsaurus.typeinfo.OptionalType;
import tech.ytsaurus.typeinfo.StructType;
import tech.ytsaurus.typeinfo.TaggedType;
import tech.ytsaurus.typeinfo.TupleType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.typeinfo.VariantType;
import tech.ytsaurus.yson.YsonConsumer;

public abstract class TiType {
    protected final TypeName typeName;

    TiType(TypeName typeName) {
        this.typeName = typeName;
    }

    public static TiType bool() {
        return NonParametrizedType.BOOL_INSTANCE;
    }

    public static TiType int8() {
        return NonParametrizedType.INT8_INSTANCE;
    }

    public static TiType int16() {
        return NonParametrizedType.INT16_INSTANCE;
    }

    public static TiType int32() {
        return NonParametrizedType.INT32_INSTANCE;
    }

    public static TiType int64() {
        return NonParametrizedType.INT64_INSTANCE;
    }

    public static TiType uint8() {
        return NonParametrizedType.UINT8_INSTANCE;
    }

    public static TiType uint16() {
        return NonParametrizedType.UINT16_INSTANCE;
    }

    public static TiType uint32() {
        return NonParametrizedType.UINT32_INSTANCE;
    }

    public static TiType uint64() {
        return NonParametrizedType.UINT64_INSTANCE;
    }

    public static TiType floatType() {
        return NonParametrizedType.FLOAT_INSTANCE;
    }

    public static TiType doubleType() {
        return NonParametrizedType.DOUBLE_INSTANCE;
    }

    public static TiType string() {
        return NonParametrizedType.STRING_INSTANCE;
    }

    public static TiType utf8() {
        return NonParametrizedType.UTF8_INSTANCE;
    }

    public static TiType date() {
        return NonParametrizedType.DATE_INSTANCE;
    }

    public static TiType datetime() {
        return NonParametrizedType.DATETIME_INSTANCE;
    }

    public static TiType timestamp() {
        return NonParametrizedType.TIMESTAMP_INSTANCE;
    }

    public static TiType tzDate() {
        return NonParametrizedType.TZ_DATE_INSTANCE;
    }

    public static TiType tzDatetime() {
        return NonParametrizedType.TZ_DATETIME_INSTANCE;
    }

    public static TiType tzTimestamp() {
        return NonParametrizedType.TZ_TIMESTAMP_INSTANCE;
    }

    public static TiType interval() {
        return NonParametrizedType.INTERVAL_INSTANCE;
    }

    public static TiType date32() {
        return NonParametrizedType.DATE32_INSTANCE;
    }

    public static TiType datetime64() {
        return NonParametrizedType.DATETIME64_INSTANCE;
    }

    public static TiType timestamp64() {
        return NonParametrizedType.TIMESTAMP64_INSTANCE;
    }

    public static TiType interval64() {
        return NonParametrizedType.INTERVAL64_INSTANCE;
    }

    public static TiType json() {
        return NonParametrizedType.JSON_INSTANCE;
    }

    public static TiType yson() {
        return NonParametrizedType.YSON_INSTANCE;
    }

    public static TiType uuid() {
        return NonParametrizedType.UUID_INSTANCE;
    }

    public static TiType voidType() {
        return NonParametrizedType.VOID_INSTANCE;
    }

    public static TiType nullType() {
        return NonParametrizedType.NULL_INSTANCE;
    }

    public static TiType decimal(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static OptionalType optional(TiType item) {
        return new OptionalType(item);
    }

    public static ListType list(TiType item) {
        return new ListType(item);
    }

    public static StructType.Builder structBuilder() {
        return StructType.builder();
    }

    public static StructType struct(StructType.Member ... members) {
        return new StructType(members);
    }

    public static StructType struct(List<StructType.Member> members) {
        return new StructType(members);
    }

    public static StructType.Member member(String name, TiType type) {
        return new StructType.Member(name, type);
    }

    public static TupleType tuple(TiType ... elements) {
        return new TupleType(elements);
    }

    public static TupleType tuple(List<TiType> elements) {
        return new TupleType(elements);
    }

    public static VariantType.Builder variantOverStructBuilder() {
        return VariantType.overStructBuilder();
    }

    public static VariantType variantOverStruct(List<StructType.Member> members) {
        return new VariantType(new StructType(members));
    }

    public static VariantType variantOverTuple(TiType ... elements) {
        return new VariantType(new TupleType(elements));
    }

    public static VariantType variantOverTuple(List<TiType> elements) {
        return new VariantType(new TupleType(elements));
    }

    public static DictType dict(TiType key, TiType value) {
        return new DictType(key, value);
    }

    public static TaggedType tagged(TiType item, String tag) {
        return new TaggedType(item, tag);
    }

    public boolean isBool() {
        return this.typeName == TypeName.Bool;
    }

    public boolean isInt8() {
        return this.typeName == TypeName.Int8;
    }

    public boolean isInt16() {
        return this.typeName == TypeName.Int16;
    }

    public boolean isInt32() {
        return this.typeName == TypeName.Int32;
    }

    public boolean isInt64() {
        return this.typeName == TypeName.Int64;
    }

    public boolean isUint8() {
        return this.typeName == TypeName.Uint8;
    }

    public boolean isUint16() {
        return this.typeName == TypeName.Uint16;
    }

    public boolean isUint32() {
        return this.typeName == TypeName.Uint32;
    }

    public boolean isUint64() {
        return this.typeName == TypeName.Uint64;
    }

    public boolean isFloat() {
        return this.typeName == TypeName.Float;
    }

    public boolean isDouble() {
        return this.typeName == TypeName.Double;
    }

    public boolean isString() {
        return this.typeName == TypeName.String;
    }

    public boolean isUtf8() {
        return this.typeName == TypeName.Utf8;
    }

    public boolean isDate() {
        return this.typeName == TypeName.Date;
    }

    public boolean isDatetime() {
        return this.typeName == TypeName.Datetime;
    }

    public boolean isTimestamp() {
        return this.typeName == TypeName.Timestamp;
    }

    public boolean isTzDate() {
        return this.typeName == TypeName.TzDate;
    }

    public boolean isTzDatetime() {
        return this.typeName == TypeName.TzDatetime;
    }

    public boolean isTzTimestamp() {
        return this.typeName == TypeName.TzTimestamp;
    }

    public boolean isInterval() {
        return this.typeName == TypeName.Interval;
    }

    public boolean isDate32() {
        return this.typeName == TypeName.Date32;
    }

    public boolean isDatetime64() {
        return this.typeName == TypeName.Datetime64;
    }

    public boolean isTimestamp64() {
        return this.typeName == TypeName.Timestamp64;
    }

    public boolean isInterval64() {
        return this.typeName == TypeName.Interval64;
    }

    public boolean isDecimal() {
        return this.typeName == TypeName.Decimal;
    }

    public boolean isJson() {
        return this.typeName == TypeName.Json;
    }

    public boolean isYson() {
        return this.typeName == TypeName.Yson;
    }

    public boolean isUuid() {
        return this.typeName == TypeName.Uuid;
    }

    public boolean isVoid() {
        return this.typeName == TypeName.Void;
    }

    public boolean isNull() {
        return this.typeName == TypeName.Null;
    }

    public boolean isOptional() {
        return this.typeName == TypeName.Optional;
    }

    public boolean isList() {
        return this.typeName == TypeName.List;
    }

    public boolean isDict() {
        return this.typeName == TypeName.Dict;
    }

    public boolean isStruct() {
        return this.typeName == TypeName.Struct;
    }

    public boolean isTuple() {
        return this.typeName == TypeName.Tuple;
    }

    public boolean isVariant() {
        return this.typeName == TypeName.Variant;
    }

    public boolean isTagged() {
        return this.typeName == TypeName.Tagged;
    }

    public DecimalType asDecimal() {
        return (DecimalType)this;
    }

    public OptionalType asOptional() {
        return (OptionalType)this;
    }

    public ListType asList() {
        return (ListType)this;
    }

    public DictType asDict() {
        return (DictType)this;
    }

    public StructType asStruct() {
        return (StructType)this;
    }

    public TupleType asTuple() {
        return (TupleType)this;
    }

    public VariantType asVariant() {
        return (VariantType)this;
    }

    public TaggedType asTaggedType() {
        return (TaggedType)this;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public boolean isNullable() {
        return this.isNull() || this.isVoid() || this.isOptional();
    }

    public abstract String toString();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract void serializeTo(YsonConsumer var1);
}

