/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeYsonConsumer;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.yson.YsonTextWriter;

public class TypeIO {
    private TypeIO() {
    }

    public static TiType parseYson(String input) {
        return TypeIO.parseYson(input.getBytes(StandardCharsets.UTF_8));
    }

    public static TiType parseYson(byte[] input) {
        YsonParser parser = new YsonParser(input);
        TypeYsonConsumer consumer = new TypeYsonConsumer();
        parser.parseNode((YsonConsumer)consumer);
        return consumer.getType();
    }

    public static TiType parseYson(Consumer<YsonConsumer> f) {
        TypeYsonConsumer ysonConsumer = new TypeYsonConsumer();
        f.accept(ysonConsumer);
        return ysonConsumer.getType();
    }

    public static void serializeToYson(TiType type, YsonConsumer consumer) {
        type.serializeTo(consumer);
    }

    public static String serializeToTextYson(TiType type) {
        StringBuilder sb = new StringBuilder();
        try (YsonTextWriter writer = new YsonTextWriter(sb);){
            TypeIO.serializeToYson(type, (YsonConsumer)writer);
        }
        return sb.toString();
    }
}

