/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum TypeName {
    Bool("bool"),
    Int8("int8"),
    Int16("int16"),
    Int32("int32"),
    Int64("int64"),
    Uint8("uint8"),
    Uint16("uint16"),
    Uint32("uint32"),
    Uint64("uint64"),
    Float("float"),
    Double("double"),
    String("string"),
    Utf8("utf8"),
    Date("date"),
    Datetime("datetime"),
    Timestamp("timestamp"),
    TzDate("tz_date"),
    TzDatetime("tz_datetime"),
    TzTimestamp("tz_timestamp"),
    Interval("interval"),
    Date32("date32"),
    Datetime64("datetime64"),
    Timestamp64("timestamp64"),
    Interval64("interval64"),
    Decimal("decimal"),
    Json("json"),
    Yson("yson"),
    Uuid("uuid"),
    Void("void"),
    Null("null"),
    Optional("optional"),
    List("list"),
    Dict("dict"),
    Struct("struct"),
    Tuple("tuple"),
    Variant("variant"),
    Tagged("tagged"),
    Extension(null);

    static final Map<ByteBuffer, TypeName> BYTE_BUFFER_MAP;
    static final Map<String, TypeName> STRING_MAP;
    @Nullable
    final String wireName;
    @Nullable
    final byte[] wireNameBytes;

    private TypeName(String wireName) {
        this.wireName = wireName;
        this.wireNameBytes = wireName == null ? null : wireName.getBytes(StandardCharsets.UTF_8);
    }

    public String getWireName() {
        if (this.wireName == null) {
            throw new IllegalArgumentException(java.lang.String.format("%s doesn't have wire name", new Object[]{this}));
        }
        return this.wireName;
    }

    public static TypeName fromWireName(String value) {
        TypeName result = STRING_MAP.get(value);
        if (result == null) {
            throw new IllegalArgumentException("Unknown type \"" + value + "\"");
        }
        return result;
    }

    public static TypeName fromWireName(byte[] value) {
        return TypeName.fromWireName(value, 0, value.length);
    }

    public static TypeName fromWireName(byte[] value, int offset, int size) {
        ByteBuffer wireName = ByteBuffer.wrap(value, offset, size);
        TypeName result = BYTE_BUFFER_MAP.get(wireName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown TypeName" + wireName);
        }
        return result;
    }

    static {
        BYTE_BUFFER_MAP = new HashMap<ByteBuffer, TypeName>();
        STRING_MAP = new HashMap<String, TypeName>();
        for (TypeName value : TypeName.values()) {
            if (value.wireName == null) continue;
            STRING_MAP.put(value.wireName, value);
            ByteBuffer byteBuffer = ByteBuffer.wrap(value.wireName.getBytes(StandardCharsets.UTF_8));
            BYTE_BUFFER_MAP.put(byteBuffer, value);
        }
    }
}

