/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.wrapper.client;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.client.YtClientConfiguration;
import tech.ytsaurus.spyt.wrapper.client.YtRpcClient;

public final class YtClientProvider$ {
    public static YtClientProvider$ MODULE$;
    private final int CLIENT_THREADS_PER_SPARK_CORE;
    private final Logger log;
    private final TrieMap<String, YtRpcClient> clients;

    static {
        new YtClientProvider$();
    }

    private int CLIENT_THREADS_PER_SPARK_CORE() {
        return this.CLIENT_THREADS_PER_SPARK_CORE;
    }

    private Logger log() {
        return this.log;
    }

    private TrieMap<String, YtRpcClient> clients() {
        return this.clients;
    }

    public TrieMap<String, YtRpcClient> getClients() {
        return this.clients();
    }

    public CompoundClient ytClient(YtClientConfiguration conf) {
        return this.ytRpcClient((Function0<YtClientConfiguration>)(Function0 & Serializable & scala.Serializable)() -> conf).yt();
    }

    public CompoundClient ytClientWithProxy(Function0<YtClientConfiguration> conf, Option<String> proxy) {
        return this.ytRpcClientWithProxy(conf, proxy).yt();
    }

    public YtRpcClient ytRpcClientWithProxy(Function0<YtClientConfiguration> conf, Option<String> proxy) {
        return this.ytRpcClient((Function0<YtClientConfiguration>)(Function0 & Serializable & scala.Serializable)() -> ((YtClientConfiguration)conf.apply()).replaceProxy(proxy));
    }

    public synchronized YtRpcClient ytRpcClient(Function0<YtClientConfiguration> conf) {
        String normalizedProxy = ((YtClientConfiguration)conf.apply()).normalizedProxy();
        return (YtRpcClient)this.clients().getOrElseUpdate((Object)normalizedProxy, (Function0 & Serializable & scala.Serializable)() -> {
            int clientThreads = MODULE$.getClientThreads();
            MODULE$.log().info(new StringBuilder(45).append("Create YtClient for proxy ").append(normalizedProxy).append(" and ").append(clientThreads).append(" clientThreads").toString());
            return YtWrapper$.MODULE$.createRpcClient((YtClientConfiguration)conf.apply(), clientThreads);
        });
    }

    public synchronized void close() {
        this.log().info("Close all YT Clients");
        this.clients().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            YtClientProvider$.$anonfun$close$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.clients().clear();
    }

    public void close(String id) {
        YtClientProvider$ ytClientProvider$ = this;
        synchronized (ytClientProvider$) {
            this.log().info(new StringBuilder(23).append("Close YT Client for id ").append(id).toString());
            this.clients().get((Object)id).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.close();
                return BoxedUnit.UNIT;
            });
            this.clients().remove((Object)id);
        }
    }

    private int getClientThreads() {
        int n;
        Option confOpt;
        Option option;
        Option option2 = Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            SparkEnv env = (SparkEnv)some.value();
            option = new Some((Object)env.conf());
        } else if (None$.MODULE$.equals(option2)) {
            option = SparkSession$.MODULE$.getDefaultSession().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sparkContext().getConf());
        } else {
            throw new MatchError((Object)option2);
        }
        Option option3 = confOpt = option;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            SparkConf conf = (SparkConf)some.value();
            n = SparkSession$.MODULE$.getDefaultSession().nonEmpty() ? conf.getInt("spark.driver.cores", 1) : BoxesRunTime.unboxToInt((Object)conf.getOption("spark.executor.cores").map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)YtClientProvider$.$anonfun$getClientThreads$2(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        } else if (None$.MODULE$.equals(option3)) {
            n = 1;
        } else {
            throw new MatchError((Object)option3);
        }
        int cores = n;
        return cores * this.CLIENT_THREADS_PER_SPARK_CORE();
    }

    public static final /* synthetic */ void $anonfun$close$1(Tuple2 x$1) {
        ((YtRpcClient)x$1._2()).close();
    }

    public static final /* synthetic */ int $anonfun$getClientThreads$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    private YtClientProvider$() {
        MODULE$ = this;
        this.CLIENT_THREADS_PER_SPARK_CORE = 2;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clients = TrieMap$.MODULE$.empty();
    }
}

