/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.ytsaurus;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.ytsaurus.Config$;
import org.apache.spark.deploy.ytsaurus.YTsaurusUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.package$;
import org.apache.spark.scheduler.cluster.ytsaurus.YTsaurusOperation;
import org.apache.spark.scheduler.cluster.ytsaurus.YTsaurusOperationManager;
import org.apache.spark.scheduler.cluster.ytsaurus.YTsaurusOperationManager$ApplicationFile$;
import org.apache.spark.util.VersionUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.YTsaurusClient;
import tech.ytsaurus.client.YTsaurusClientConfig;
import tech.ytsaurus.client.request.GetOperation;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.spyt.BuildInfo$;
import tech.ytsaurus.spyt.SparkVersionUtils$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeListNode;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeStringNode;

public final class YTsaurusOperationManager$
implements Logging {
    public static YTsaurusOperationManager$ MODULE$;
    private final String SPARK_TMP_DIR_PREFIX;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final double NON_JVM_MEMORY_OVERHEAD_FACTOR;
    private final int DEFAULT_DRIVER_PORT;
    private final long MIB;
    private final String DRIVER_TASK;
    private final String EXECUTOR_TASK;
    private final Set<String> finalStates;
    private final String WEB_UI_KEY;
    private final List<String> WEB_UI_PATH;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new YTsaurusOperationManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public YTsaurusOperationManager create(String ytProxy, SparkConf conf, Option<String> networkName, Option<String> proxyRole) {
        YTsaurusOperationManager yTsaurusOperationManager;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Entering YTsaurusOperationManager.create");
        Tuple2<String, String> tuple2 = YTsaurusUtils$.MODULE$.userAndToken(conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String user = (String)tuple2._1();
        String token = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)user, (Object)token);
        Tuple2 tuple23 = tuple22;
        String user2 = (String)tuple23._1();
        String token2 = (String)tuple23._2();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "User and token were retrieved, now creating YTsaurus client");
        YTsaurusClient ytClient = this.buildClient(ytProxy, user2, token2, networkName, proxyRole, conf);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "YTsaurus client has been successfully created");
        try {
            BoxedUnit boxedUnit;
            String driverJavaOptions;
            Optional optional;
            YTreeNode yTreeNode;
            String globalConfigPath = (String)conf.get(Config$.MODULE$.GLOBAL_CONFIG_PATH());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrieving global SPYT config");
            YTreeMapNode globalConfig = this.getDocument(ytClient, globalConfigPath);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Global SPYT config has been successfully retrieved");
            boolean isSquashFs = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.YTSAURUS_SQUASHFS_ENABLED()));
            Object object = !conf.contains(Config$.MODULE$.SPYT_VERSION()) ? conf.set(Config$.MODULE$.SPYT_VERSION(), (Object)BuildInfo$.MODULE$.version()) : BoxedUnit.UNIT;
            String spytVersion = conf.get(Config$.MODULE$.SPYT_VERSION().key());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Used SPYT version: ").append(spytVersion).toString());
            YTreeMapNode environment = globalConfig.getMap("environment");
            String javaHome = (String)conf.get(Config$.MODULE$.YTSAURUS_JAVA_HOME());
            environment.put("JAVA_HOME", (YTreeNode)YTree.stringNode((String)javaHome));
            String releaseConfigPath = new StringBuilder(2).append(conf.get(Config$.MODULE$.RELEASE_CONFIG_PATH())).append("/").append(spytVersion).append("/").append(conf.get(Config$.MODULE$.LAUNCH_CONF_FILE())).toString();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrieving release SPYT config");
            YTreeMapNode releaseConfig = this.getDocument(ytClient, releaseConfigPath);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Release SPYT config has been successfully retrieved");
            String sv = package$.MODULE$.SPARK_VERSION_SHORT();
            Tuple3 tuple3 = (Tuple3)VersionUtils$.MODULE$.majorMinorPatchVersion(sv).get();
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int svMajor = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int svMinor = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int svPatch = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)svMajor), (Object)BoxesRunTime.boxToInteger((int)svMinor), (Object)BoxesRunTime.boxToInteger((int)svPatch));
            Tuple3 tuple33 = tuple32;
            int svMajor2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int svMinor2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            int svPatch2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            String distrRootPath = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(Config$.MODULE$.SPARK_DISTRIBUTIVES_PATH()), BoxesRunTime.boxToInteger((int)svMajor2), BoxesRunTime.boxToInteger((int)svMinor2), BoxesRunTime.boxToInteger((int)svPatch2)}))).mkString("/");
            String distrExtension = isSquashFs ? ".squashfs" : ".tgz";
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Looking for SPYT distributive path on cypress");
            Option distrPathOpt = new Some((Object)distrRootPath).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean((Boolean)ytClient.existsNode(path).join()))).flatMap((Function1 & Serializable & scala.Serializable)path -> {
                java.util.List distrRootContents = ((YTreeNode)ytClient.listNode(path).join()).asList();
                return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(distrRootContents).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)YTsaurusOperationManager$.$anonfun$create$12(distrExtension, x$11)));
            });
            if (distrPathOpt.isEmpty()) {
                throw new SparkException(new StringBuilder(55).append("Spark ").append(sv).append(" ").append(distrExtension.substring(1)).append(" distributive doesn't exist ").append("at path ").append(distrRootPath).append(" on cluster ").append(ytProxy).toString());
            }
            String sparkDistr = ((YTreeNode)distrPathOpt.get()).stringValue();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("SPYT distributive was found at ").append(sparkDistr).toString());
            if (conf.contains(Config$.MODULE$.DRIVER_OPERATION_ID())) {
                String driverOpId = conf.get(Config$.MODULE$.DRIVER_OPERATION_ID());
                YTreeNode driverOperation = this.getOperation(new YTsaurusOperation(GUID.valueOf((String)driverOpId)), ytClient);
                yTreeNode = this.getDriverFilePaths(driverOperation);
            } else {
                YTreeListNode filePathsList = releaseConfig.getListO("file_paths").orElse(YTree.listBuilder().buildList());
                this.applicationFiles(conf, this.localFileToCacheUploader(conf, ytClient)).foreach((Function1 & Serializable & scala.Serializable)appFile -> {
                    YTsaurusOperationManager$.$anonfun$create$14(filePathsList, appFile);
                    return BoxedUnit.UNIT;
                });
                if (isSquashFs) {
                    Option spytPackagePosOpt = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), filePathsList.size()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> filePathsList.getString(i).endsWith("spyt-package.zip"));
                    spytPackagePosOpt.foreach((Function1 & Serializable & scala.Serializable)pos -> filePathsList.remove(BoxesRunTime.unboxToInt((Object)pos)));
                } else {
                    filePathsList.add((YTreeNode)YTree.stringNode((String)new StringBuilder(1).append(distrRootPath).append("/").append(sparkDistr).toString()));
                }
                yTreeNode = filePathsList;
            }
            YTreeNode filePaths = yTreeNode;
            YTreeNode layerPaths = this.getLayerPaths(conf, releaseConfig, new StringBuilder(1).append(distrRootPath).append("/").append(sparkDistr).toString());
            this.enrichSparkConf(conf, releaseConfig);
            this.enrichSparkConf(conf, globalConfig);
            String javaCommand = new StringBuilder(9).append(javaHome).append("/bin/java").toString();
            String home = ".";
            String sparkHome = isSquashFs ? "/usr/lib/spark" : new StringBuilder(6).append(home).append("/spark").toString();
            String spytHome = isSquashFs ? "/usr/lib/spyt" : new StringBuilder(13).append(home).append("/spyt-package").toString();
            String sparkClassPath = new StringBuilder(25).append(home).append("/*:").append(spytHome).append("/conf/:").append(spytHome).append("/jars/*:").append(sparkHome).append("/jars/*").toString();
            environment.put("SPARK_HOME", (YTreeNode)YTree.stringNode((String)sparkHome));
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.YTSAURUS_IS_PYTHON_BINARY()))) {
                YTreeStringNode pyBinaryWrapper = YTree.stringNode((String)YTsaurusUtils$.MODULE$.pythonBinaryWrapperPath(spytHome));
                environment.put("PYSPARK_EXECUTOR_PYTHON", (YTreeNode)pyBinaryWrapper);
                Object object2 = conf.get(org.apache.spark.internal.config.package$.MODULE$.SUBMIT_DEPLOY_MODE());
                String string = "cluster";
                optional = !(object2 != null ? !object2.equals(string) : string != null) ? environment.put("PYSPARK_DRIVER_PYTHON", (YTreeNode)pyBinaryWrapper) : BoxedUnit.UNIT;
            } else {
                optional = environment.put("PYTHONPATH", (YTreeNode)YTree.stringNode((String)new StringBuilder(7).append(spytHome).append("/python").toString()));
            }
            environment.put("SPARK_YT_RPC_JOB_PROXY_ENABLED", (YTreeNode)YTree.stringNode((String)conf.get(Config$.MODULE$.YTSAURUS_RPC_JOB_PROXY_ENABLED()).toString()));
            conf.set("spark.executor.resource.gpu.discoveryScript", new StringBuilder(24).append(spytHome).append("/bin/getGpusResources.sh").toString());
            ArrayBuffer ytsaurusJavaOptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ytsaurusJavaOptions.$plus$eq((Object)new StringBuilder(22).append("$(cat ").append(spytHome).append("/conf/java-opts)").toString());
            Object object3 = conf.getBoolean("spark.hadoop.yt.preferenceIpv6.enabled", false) ? (SparkVersionUtils$.MODULE$.lessThan("3.4.0") ? ytsaurusJavaOptions.$plus$eq((Object)"-Djava.net.preferIPv6Addresses=true") : (!(driverJavaOptions = (String)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.DRIVER_JAVA_OPTIONS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).contains("java.net.preferIPv6Addresses") ? conf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_JAVA_OPTIONS(), (Object)new StringBuilder(36).append("-Djava.net.preferIPv6Addresses=true ").append(driverJavaOptions).toString()) : BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            if (!conf.contains(Config$.MODULE$.YTSAURUS_CUDA_VERSION())) {
                String cudaVersion = globalConfig.getStringO("cuda_toolkit_version").orElse("11.0");
                boxedUnit = conf.set(Config$.MODULE$.YTSAURUS_CUDA_VERSION(), (Object)cudaVersion);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String prepareEnvParameters = isSquashFs ? "--use-squashfs" : new StringBuilder(35).append("--spark-home ").append(home).append(" --spark-distributive ").append(sparkDistr).toString();
            String prepareEnvCommand = new StringBuilder(97).append("./setup-spyt-env.sh ").append(prepareEnvParameters).append(" ").append("&& export SPARK_LOCAL_DIRS=\"${YT_SPARK_LOCAL_DIRS:-/tmp}/${YT_OPERATION_ID}\"").toString();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating YTsaurusOperationManager instance");
            yTsaurusOperationManager = new YTsaurusOperationManager(ytClient, user2, token2, layerPaths, filePaths, environment, home, prepareEnvCommand, sparkClassPath, javaCommand, (Seq<String>)ytsaurusJavaOptions);
        }
        catch (Throwable t) {
            ytClient.close();
            throw t;
        }
        return yTsaurusOperationManager;
    }

    public YTreeNode getOperation(YTsaurusOperation operation, YTsaurusClient ytClient) {
        GetOperation request = ((GetOperation.BuilderBase)GetOperation.builder().setOperationId(operation.id())).build();
        return (YTreeNode)ytClient.getOperation(request).join();
    }

    public YTreeNode getLayerPaths(SparkConf conf, YTreeMapNode releaseConfig, String sparkDistr) {
        YTreeListNode layerPaths = YTree.listBuilder().buildList();
        ((Option)conf.get(Config$.MODULE$.YTSAURUS_EXTRA_PORTO_LAYER_PATHS())).foreach((Function1 & Serializable & scala.Serializable)extraLayers -> {
            YTsaurusOperationManager$.$anonfun$getLayerPaths$1(layerPaths, extraLayers);
            return BoxedUnit.UNIT;
        });
        String layerPathsKey = "layer_paths";
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.YTSAURUS_SQUASHFS_ENABLED()))) {
            layerPaths.add((YTreeNode)YTree.stringNode((String)new StringBuilder(22).append(releaseConfig.getString("spark_yt_base_path")).append("/spyt-package.squashfs").toString()));
            layerPaths.add((YTreeNode)YTree.stringNode((String)sparkDistr));
            layerPathsKey = "squashfs_layer_paths";
        }
        YTreeListNode defaultLayers = releaseConfig.getListO(layerPathsKey).orElse(YTree.listBuilder().buildList());
        if (conf.contains(Config$.MODULE$.YTSAURUS_PORTO_LAYER_PATHS())) {
            ((Option)conf.get(Config$.MODULE$.YTSAURUS_PORTO_LAYER_PATHS())).foreach((Function1 & Serializable & scala.Serializable)layers -> {
                YTsaurusOperationManager$.$anonfun$getLayerPaths$3(layerPaths, layers);
                return BoxedUnit.UNIT;
            });
        } else {
            defaultLayers.forEach(layer -> layerPaths.add((YTreeNode)YTree.stringNode((String)layer.stringValue())));
        }
        return layerPaths;
    }

    public YTreeMapNode getDocument(YTsaurusClient ytClient, String path) {
        YTreeMapNode yTreeMapNode;
        if (Predef$.MODULE$.Boolean2boolean((Boolean)ytClient.existsNode(path).join())) {
            yTreeMapNode = ((YTreeNode)ytClient.getNode(path).join()).mapNode();
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Document at path ").append(path).append(" does not exist").toString());
            yTreeMapNode = YTree.mapBuilder().buildMap();
        }
        return yTreeMapNode;
    }

    public Function1<String, String> localFileToCacheUploader(SparkConf conf, YTsaurusClient ytClient) {
        return (Function1 & Serializable & scala.Serializable)path -> {
            String remoteTempFilesDirectory = (String)conf.get(Config$.MODULE$.YTSAURUS_REMOTE_TEMP_FILES_DIRECTORY());
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Uploading ").append((String)path).append(" to cypress cache at ").append(remoteTempFilesDirectory).toString());
            return YtWrapper$.MODULE$.uploadFileToCache(path, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(7)).days(), remoteTempFilesDirectory, (CompoundClient)ytClient);
        };
    }

    public Seq<YTsaurusOperationManager.ApplicationFile> extractYtFiles(Seq<String> files, Function1<String, String> uploadToCache, boolean isArchive) {
        return (Seq)files.map((Function1 & Serializable & scala.Serializable)fileName -> MODULE$.prepareFile((String)fileName, uploadToCache, isArchive), Seq$.MODULE$.canBuildFrom());
    }

    public boolean extractYtFiles$default$3() {
        return false;
    }

    private YTsaurusOperationManager.ApplicationFile prepareFile(String fileName, Function1<String, String> uploadToCache, boolean isArchive) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(fileName)).split('#');
        int n = parts.length;
        switch (n) {
            case 1: {
                tuple23 = new Tuple2((Object)fileName, (Object)None$.MODULE$);
                break;
            }
            case 2: {
                tuple23 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).head(), (Object)new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last()));
                break;
            }
            default: {
                throw new SparkException(new StringBuilder(14).append("Too many '#': ").append(fileName).toString());
            }
        }
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String sourceName = (String)tuple24._1();
        Option specifiedName = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)sourceName, (Object)specifiedName);
        Tuple2 tuple26 = tuple25;
        String sourceName2 = (String)tuple26._1();
        Option specifiedName2 = (Option)tuple26._2();
        if (sourceName2.startsWith("yt:/")) {
            tuple22 = new Tuple2((Object)YtWrapper$.MODULE$.formatPath(sourceName2), (Object)specifiedName2);
        } else {
            URI uri = URI.create(sourceName2);
            tuple22 = tuple2 = new Tuple2(uploadToCache.apply((Object)uri.getPath()), (Object)specifiedName2.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)((Object)Paths.get(uri.getPath(), new String[0]).getFileName()).toString())));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String ytFileName = (String)tuple2._1();
        Option targetName = (Option)tuple2._2();
        Tuple2 tuple27 = new Tuple2((Object)ytFileName, (Object)targetName);
        Tuple2 tuple28 = tuple27;
        String ytFileName2 = (String)tuple28._1();
        Option targetName2 = (Option)tuple28._2();
        return new YTsaurusOperationManager.ApplicationFile(ytFileName2, (Option<String>)targetName2, isArchive, YTsaurusOperationManager$ApplicationFile$.MODULE$.apply$default$4());
    }

    private String SPARK_TMP_DIR_PREFIX() {
        return this.SPARK_TMP_DIR_PREFIX;
    }

    public Seq<YTsaurusOperationManager.ApplicationFile> applicationFiles(SparkConf conf, Function1<String, String> uploadToCache) {
        Seq files = (Seq)((TraversableLike)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JARS(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.FILES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.ARCHIVES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.SUBMIT_PYTHON_FILES(), (List)Nil$.MODULE$))))).flatMap((Function1 & Serializable & scala.Serializable)k -> {
            ConfigEntry configEntry = k;
            ConfigEntry configEntry2 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
            return MODULE$.extractYtFiles((Seq<String>)((Seq)((TraversableLike)conf.get(k)).filter((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)YTsaurusOperationManager$.$anonfun$applicationFiles$2(res)))), uploadToCache, !(configEntry != null ? !configEntry.equals(configEntry2) : configEntry2 != null));
        }, Seq$.MODULE$.canBuildFrom());
        Seq primaryResource = (Seq)this.extractYtFiles((Seq<String>)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)conf.get(Config$.MODULE$.SPARK_PRIMARY_RESOURCE())).filter((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)YTsaurusOperationManager$.$anonfun$applicationFiles$3(res)))).toSeq(), uploadToCache, this.extractYtFiles$default$3()).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            boolean x$1 = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.YTSAURUS_IS_PYTHON_BINARY()));
            String x$2 = x$14.copy$default$1();
            Option<String> x$3 = x$14.copy$default$2();
            boolean x$4 = x$14.copy$default$3();
            return x$14.copy(x$2, x$3, x$4, x$1);
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((SeqLike)files.$plus$plus((GenTraversableOnce)primaryResource, Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public void enrichSparkConf(SparkConf conf, YTreeMapNode ytSparkConfig) {
        block1: {
            if (ytSparkConfig.containsKey("spark_conf")) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)ytSparkConfig.getMap("spark_conf")).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> !conf.contains((String)entry.getKey()) ? conf.set((String)entry.getKey(), ((YTreeNode)entry.getValue()).stringNode().getValue()) : BoxedUnit.UNIT);
            }
            if (!ytSparkConfig.containsKey("enablers")) break block1;
            YTreeMapNode enablers = ytSparkConfig.getMap("enablers");
            enablers.keys().forEach(enabler -> {
                block1: {
                    boolean updatedValue;
                    if (!conf.contains(enabler)) break block1;
                    boolean confValue = conf.getBoolean(enabler, false);
                    boolean bl = updatedValue = confValue && enablers.getBool(enabler);
                    if (confValue != updatedValue) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Property ").append((String)enabler).append(" was explicitly set to ").append(updatedValue).append(" because of cluster settings").toString());
                        conf.set(enabler, Boolean.toString(updatedValue));
                    }
                }
            });
        }
    }

    public double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public double NON_JVM_MEMORY_OVERHEAD_FACTOR() {
        return this.NON_JVM_MEMORY_OVERHEAD_FACTOR;
    }

    public int DEFAULT_DRIVER_PORT() {
        return this.DEFAULT_DRIVER_PORT;
    }

    public long MIB() {
        return this.MIB;
    }

    public String DRIVER_TASK() {
        return this.DRIVER_TASK;
    }

    public String EXECUTOR_TASK() {
        return this.EXECUTOR_TASK;
    }

    private Set<String> finalStates() {
        return this.finalStates;
    }

    public String WEB_UI_KEY() {
        return this.WEB_UI_KEY;
    }

    private List<String> WEB_UI_PATH() {
        return this.WEB_UI_PATH;
    }

    public String getOperationState(YTreeNode operation) {
        return operation.mapNode().getStringO("state").orElse("undefined");
    }

    private YTreeNode getDriverFilePaths(YTreeNode operation) {
        return operation.mapNode().getMap("provided_spec").getMap("tasks").getMap("driver").getList("file_paths");
    }

    public boolean isCompletedState(String currentState) {
        String string = currentState;
        String string2 = "completed";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isFinalState(String currentState) {
        return this.finalStates().contains((Object)currentState);
    }

    public Option<String> getWebUIAddress(YTreeNode operation) {
        Option description = (Option)this.WEB_UI_PATH().foldLeft((Object)new Some((Object)operation), (Function2 & Serializable & scala.Serializable)(yTreeOpt, key) -> yTreeOpt.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.asMap()).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.containsKey(key))).map((Function1 & Serializable & scala.Serializable)x$17 -> (YTreeNode)x$17.get(key)));
        return description.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isStringNode())).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.stringNode().getValue());
    }

    private YTsaurusClient buildClient(String ytProxy, String user, String token, Option<String> networkName, Option<String> proxyRole, SparkConf conf) {
        YTsaurusClient.ClientBuilder builder = YTsaurusClient.builder();
        builder.setCluster(ytProxy);
        ((Option)conf.get(Config$.MODULE$.YTSAURUS_CLIENT_TIMEOUT())).foreach((Function1 & Serializable & scala.Serializable)timeoutMilis -> YTsaurusOperationManager$.$anonfun$buildClient$1(builder, BoxesRunTime.unboxToLong((Object)timeoutMilis)));
        networkName.foreach((Function1 & Serializable & scala.Serializable)nn -> builder.setProxyNetworkName(nn));
        proxyRole.foreach((Function1 & Serializable & scala.Serializable)pr -> builder.setProxyRole(pr));
        Object object = user != null && token != null ? builder.setAuth(YTsaurusClientAuth.builder().setUser(user).setToken(token).build()) : BoxedUnit.UNIT;
        return (YTsaurusClient)builder.build();
    }

    public static final /* synthetic */ boolean $anonfun$create$12(String distrExtension$1, YTreeNode x$11) {
        return x$11.stringValue().endsWith(distrExtension$1);
    }

    public static final /* synthetic */ void $anonfun$create$14(YTreeListNode filePathsList$1, YTsaurusOperationManager.ApplicationFile appFile) {
        YTreeStringNode node = YTree.stringNode((String)appFile.ytPath());
        node.putAttribute("file_name", (YTreeNode)YTree.stringNode((String)appFile.downloadName()));
        Object object = appFile.isExecutable() ? node.putAttribute("executable", (YTreeNode)YTree.booleanNode((boolean)true)) : BoxedUnit.UNIT;
        filePathsList$1.add((YTreeNode)node);
    }

    public static final /* synthetic */ void $anonfun$getLayerPaths$1(YTreeListNode layerPaths$1, String extraLayers) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(extraLayers)).split(','))).foreach((Function1 & Serializable & scala.Serializable)layer -> {
            layerPaths$1.add((YTreeNode)YTree.stringNode((String)layer));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getLayerPaths$3(YTreeListNode layerPaths$1, String layers) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(layers)).split(','))).foreach((Function1 & Serializable & scala.Serializable)layer -> {
            layerPaths$1.add((YTreeNode)YTree.stringNode((String)layer));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$applicationFiles$2(String res) {
        return !res.startsWith(MODULE$.SPARK_TMP_DIR_PREFIX());
    }

    public static final /* synthetic */ boolean $anonfun$applicationFiles$3(String res) {
        String string = res;
        String string2 = "spark-internal";
        return (string == null ? string2 != null : !string.equals(string2)) && !YTsaurusUtils$.MODULE$.isShell(res);
    }

    public static final /* synthetic */ Object $anonfun$buildClient$1(YTsaurusClient.ClientBuilder builder$1, long timeoutMilis) {
        RpcOptions rpcOptions = new RpcOptions();
        java.time.Duration timeoutDuration = java.time.Duration.ofMillis(timeoutMilis);
        rpcOptions.setGlobalTimeout(timeoutDuration);
        rpcOptions.setStreamingReadTimeout(timeoutDuration);
        rpcOptions.setStreamingWriteTimeout(timeoutDuration);
        return builder$1.setConfig(YTsaurusClientConfig.builder().setRpcOptions(rpcOptions).build());
    }

    private YTsaurusOperationManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.SPARK_TMP_DIR_PREFIX = new StringBuilder(6).append(System.getProperty("java.io.tmpdir")).append("/spark").toString();
        this.MEMORY_OVERHEAD_FACTOR = 0.1;
        this.NON_JVM_MEMORY_OVERHEAD_FACTOR = 0.4;
        this.DEFAULT_DRIVER_PORT = 27001;
        this.MIB = 0x100000L;
        this.DRIVER_TASK = "driver";
        this.EXECUTOR_TASK = "executor";
        this.finalStates = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completed", "failed", "aborted", "lost"}));
        this.WEB_UI_KEY = "Web UI";
        this.WEB_UI_PATH = new .colon.colon((Object)"runtime_parameters", (List)new .colon.colon((Object)"annotations", (List)new .colon.colon((Object)"description", (List)new .colon.colon((Object)this.WEB_UI_KEY(), (List)Nil$.MODULE$))));
    }
}

