function test_suite=test_assert_equal()
    try % assignment of 'localfunctions' is necessary in Matlab >= 2016
        test_functions=localfunctions();
    catch % no problem; early Matlab versions can use initTestSuite fine
    end
    initTestSuite;

function test_assert_equal_exceptions
    assertExceptionThrown(@()assertEqual(...
                                [1],'a'),...
                                        'assertEqual:classNotEqual');
    assertExceptionThrown(@()assertEqual(...
                                [1 2],[1;2]),...
                                        'assertEqual:nonEqual');
    assertExceptionThrown(@()assertEqual(...
                                sparse(1),1),...
                                        'assertEqual:sparsityNotEqual');
    assertExceptionThrown(@()assertEqual(...
                                [1 2],[1 3]),...
                                        'assertEqual:nonEqual');

function test_assert_equal_passes
    assertEqual(1,1);
    assertEqual(struct(),struct());
    assertEqual({1,'a'},{1,'a'});
