"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncInvokeConfig = exports.AsyncInvokeConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "AsyncInvokeConfigProperty", { enumerable: true, get: function () { return fc3_generated_1.RosAsyncInvokeConfig; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::AsyncInvokeConfig`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAsyncInvokeConfig`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-asyncinvokeconfig
 */
class AsyncInvokeConfig extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAsyncInvokeConfig = new fc3_generated_1.RosAsyncInvokeConfig(this, id, {
            maxAsyncEventAgeInSeconds: props.maxAsyncEventAgeInSeconds,
            functionName: props.functionName,
            destinationConfig: props.destinationConfig,
            asyncTask: props.asyncTask,
            maxAsyncRetryAttempts: props.maxAsyncRetryAttempts,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAsyncInvokeConfig;
    }
}
exports.AsyncInvokeConfig = AsyncInvokeConfig;
//# sourceMappingURL=data:application/json;base64,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