"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcurrencyConfig = exports.ConcurrencyConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "ConcurrencyConfigProperty", { enumerable: true, get: function () { return fc3_generated_1.RosConcurrencyConfig; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::ConcurrencyConfig`, which is used to configure reserved concurrency for a function in Function Compute 3.0.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosConcurrencyConfig`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-concurrencyconfig
 */
class ConcurrencyConfig extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosConcurrencyConfig = new fc3_generated_1.RosConcurrencyConfig(this, id, {
            functionName: props.functionName,
            reservedConcurrency: props.reservedConcurrency,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosConcurrencyConfig;
    }
}
exports.ConcurrencyConfig = ConcurrencyConfig;
//# sourceMappingURL=data:application/json;base64,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