"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Function = exports.FunctionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "FunctionProperty", { enumerable: true, get: function () { return fc3_generated_1.RosFunction; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::Function`, which is used to create a Function Compute 3.0 function.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosFunction`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-function
 */
class Function extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosFunction = new fc3_generated_1.RosFunction(this, id, {
            description: props.description,
            tracingConfig: props.tracingConfig,
            vpcConfig: props.vpcConfig,
            instanceLifecycleConfig: props.instanceLifecycleConfig,
            cpu: props.cpu,
            sessionAffinityConfig: props.sessionAffinityConfig,
            functionName: props.functionName,
            runtime: props.runtime,
            environmentVariables: props.environmentVariables,
            disableOndemand: props.disableOndemand,
            diskSize: props.diskSize,
            customDns: props.customDns,
            instanceConcurrency: props.instanceConcurrency,
            layers: props.layers,
            tags: props.tags,
            nasConfig: props.nasConfig,
            instanceIsolationMode: props.instanceIsolationMode,
            memorySize: props.memorySize,
            timeout: props.timeout,
            handler: props.handler,
            customContainerConfig: props.customContainerConfig,
            code: props.code,
            role: props.role,
            internetAccess: props.internetAccess,
            customRuntimeConfig: props.customRuntimeConfig,
            gpuConfig: props.gpuConfig,
            sessionAffinity: props.sessionAffinity,
            ossMountConfig: props.ossMountConfig,
            logConfig: props.logConfig,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFunction;
        this.attrArn = rosFunction.attrArn;
        this.attrFunctionId = rosFunction.attrFunctionId;
        this.attrFunctionName = rosFunction.attrFunctionName;
    }
}
exports.Function = Function;
//# sourceMappingURL=data:application/json;base64,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