"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trigger = exports.TriggerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "TriggerProperty", { enumerable: true, get: function () { return fc3_generated_1.RosTrigger; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::Trigger`, which is used to create a Function Compute 3.0 trigger.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTrigger`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-trigger
 */
class Trigger extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTrigger = new fc3_generated_1.RosTrigger(this, id, {
            triggerType: props.triggerType,
            functionName: props.functionName,
            description: props.description,
            triggerName: props.triggerName,
            sourceArn: props.sourceArn,
            triggerConfig: props.triggerConfig,
            invocationRole: props.invocationRole,
            qualifier: props.qualifier,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrigger;
        this.attrFunctionName = rosTrigger.attrFunctionName;
        this.attrTriggerId = rosTrigger.attrTriggerId;
        this.attrTriggerName = rosTrigger.attrTriggerName;
        this.attrUrlInternet = rosTrigger.attrUrlInternet;
        this.attrUrlIntranet = rosTrigger.attrUrlIntranet;
    }
}
exports.Trigger = Trigger;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJpZ2dlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyaWdnZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUE2QztBQUV0QixnR0FGZCwwQkFBVSxPQUVtQjtBQWdGdEM7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBK0JyQzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFtQixFQUFFLG1DQUEyQyxJQUFJO1FBQzlHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDYixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFFekUsTUFBTSxVQUFVLEdBQUcsSUFBSSwwQkFBVSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDekMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztTQUM3QixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFVBQVUsQ0FBQztRQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3BELElBQUksQ0FBQyxhQUFhLEdBQUcsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUM5QyxJQUFJLENBQUMsZUFBZSxHQUFHLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDbEQsSUFBSSxDQUFDLGVBQWUsR0FBRyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ2xELElBQUksQ0FBQyxlQUFlLEdBQUcsVUFBVSxDQUFDLGVBQWUsQ0FBQztJQUN0RCxDQUFDO0NBQ0o7QUE1REQsMEJBNERDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zVHJpZ2dlciB9IGZyb20gJy4vZmMzLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1RyaWdnZXIgYXMgVHJpZ2dlclByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgVHJpZ2dlcmAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1mYzMtdHJpZ2dlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRyaWdnZXJQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBmdW5jdGlvbk5hbWU6IFRoZSBuYW1lIG9mIHRoZSBmdW5jdGlvbi5cbiAgICAgKi9cbiAgICByZWFkb25seSBmdW5jdGlvbk5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRyaWdnZXJDb25maWc6IFRyaWdnZXIgY29uZmlnLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRyaWdnZXJDb25maWc6IHsgW2tleTogc3RyaW5nXTogKGFueSB8IHJvcy5JUmVzb2x2YWJsZSkgfSB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRyaWdnZXJOYW1lOiBOYW1lIG9mIHRoZSB0cmlnZ2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRyaWdnZXJOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0cmlnZ2VyVHlwZTogVHlwZSBvZiB0aGUgdHJpZ2dlci5cbiAgICAgKi9cbiAgICByZWFkb25seSB0cmlnZ2VyVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVzY3JpcHRpb246IERlc2NyaXB0aW9uIG9mIHRoZSB0cmlnZ2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW52b2NhdGlvblJvbGU6IEludm9jYXRpb24gcm9sZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnZvY2F0aW9uUm9sZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHF1YWxpZmllcjogUXVhbGlmaWVyIG9mIHRoZSB0cmlnZ2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHF1YWxpZmllcj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNvdXJjZUFybjogU291cmNlIEFSTiBvZiB0aGUgdHJpZ2dlci5cbiAgICAgKi9cbiAgICByZWFkb25seSBzb3VyY2VBcm4/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGBUcmlnZ2VyYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJVHJpZ2dlciBleHRlbmRzIHJvcy5JUmVzb3VyY2Uge1xuICAgIHJlYWRvbmx5IHByb3BzOiBUcmlnZ2VyUHJvcHM7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRnVuY3Rpb25OYW1lOiBGdW5jdGlvbiBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF0dHJGdW5jdGlvbk5hbWU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUcmlnZ2VySWQ6IFRoZSB0cmlnZ2VyIElELlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF0dHJUcmlnZ2VySWQ6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUcmlnZ2VyTmFtZTogVHJpZ2dlciBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF0dHJUcmlnZ2VyTmFtZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFVybEludGVybmV0OiBUaGUgcHVibGljIGRvbWFpbiBhZGRyZXNzLiBZb3UgY2FuIGFjY2VzcyBIVFRQIHRyaWdnZXJzIG92ZXIgdGhlIEludGVybmV0IGJ5IHVzaW5nIEhUVFAgb3IgSFRUUFMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0clVybEludGVybmV0OiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgVXJsSW50cmFuZXQ6IFRoZSBwcml2YXRlIGVuZHBvaW50LiBJbiBhIFZQQywgeW91IGNhbiBhY2Nlc3MgSFRUUCB0cmlnZ2VycyBieSB1c2luZyBIVFRQIG9yIEhUVFBTLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF0dHJVcmxJbnRyYW5ldDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xufVxuLyoqXG4gKiBUaGlzIGNsYXNzIGVuY2Fwc3VsYXRlcyBhbmQgZXh0ZW5kcyB0aGUgUk9TIHJlc291cmNlIHR5cGUgYEFMSVlVTjo6RkMzOjpUcmlnZ2VyYCwgd2hpY2ggaXMgdXNlZCB0byBjcmVhdGUgYSBGdW5jdGlvbiBDb21wdXRlIDMuMCB0cmlnZ2VyLlxuICogQE5vdGUgVGhpcyBjbGFzcyBtYXkgaGF2ZSBzb21lIG5ldyBmdW5jdGlvbnMgdG8gZmFjaWxpdGF0ZSBkZXZlbG9wbWVudCwgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoaXMgY2xhc3MgaW5zdGVhZCBvZiBgUm9zVHJpZ2dlcmBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWZjMy10cmlnZ2VyXG4gKi9cbmV4cG9ydCBjbGFzcyBUcmlnZ2VyIGV4dGVuZHMgcm9zLlJlc291cmNlIGltcGxlbWVudHMgSVRyaWdnZXIge1xuICAgIHByb3RlY3RlZCBzY29wZTogcm9zLkNvbnN0cnVjdDtcbiAgICBwcm90ZWN0ZWQgaWQ6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IFRyaWdnZXJQcm9wcztcbiAgICBwcm90ZWN0ZWQgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRnVuY3Rpb25OYW1lOiBGdW5jdGlvbiBuYW1lLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRnVuY3Rpb25OYW1lOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgVHJpZ2dlcklkOiBUaGUgdHJpZ2dlciBJRC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clRyaWdnZXJJZDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFRyaWdnZXJOYW1lOiBUcmlnZ2VyIG5hbWUuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJUcmlnZ2VyTmFtZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFVybEludGVybmV0OiBUaGUgcHVibGljIGRvbWFpbiBhZGRyZXNzLiBZb3UgY2FuIGFjY2VzcyBIVFRQIHRyaWdnZXJzIG92ZXIgdGhlIEludGVybmV0IGJ5IHVzaW5nIEhUVFAgb3IgSFRUUFMuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJVcmxJbnRlcm5ldDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFVybEludHJhbmV0OiBUaGUgcHJpdmF0ZSBlbmRwb2ludC4gSW4gYSBWUEMsIHlvdSBjYW4gYWNjZXNzIEhUVFAgdHJpZ2dlcnMgYnkgdXNpbmcgSFRUUCBvciBIVFRQUy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clVybEludHJhbmV0OiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVHJpZ2dlclByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICB0aGlzLnNjb3BlID0gc2NvcGU7XG4gICAgICAgIHRoaXMuaWQgPSBpZDtcbiAgICAgICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG5cbiAgICAgICAgY29uc3Qgcm9zVHJpZ2dlciA9IG5ldyBSb3NUcmlnZ2VyKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgdHJpZ2dlclR5cGU6IHByb3BzLnRyaWdnZXJUeXBlLFxuICAgICAgICAgICAgZnVuY3Rpb25OYW1lOiBwcm9wcy5mdW5jdGlvbk5hbWUsXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICAgICAgICB0cmlnZ2VyTmFtZTogcHJvcHMudHJpZ2dlck5hbWUsXG4gICAgICAgICAgICBzb3VyY2VBcm46IHByb3BzLnNvdXJjZUFybixcbiAgICAgICAgICAgIHRyaWdnZXJDb25maWc6IHByb3BzLnRyaWdnZXJDb25maWcsXG4gICAgICAgICAgICBpbnZvY2F0aW9uUm9sZTogcHJvcHMuaW52b2NhdGlvblJvbGUsXG4gICAgICAgICAgICBxdWFsaWZpZXI6IHByb3BzLnF1YWxpZmllcixcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NUcmlnZ2VyO1xuICAgICAgICB0aGlzLmF0dHJGdW5jdGlvbk5hbWUgPSByb3NUcmlnZ2VyLmF0dHJGdW5jdGlvbk5hbWU7XG4gICAgICAgIHRoaXMuYXR0clRyaWdnZXJJZCA9IHJvc1RyaWdnZXIuYXR0clRyaWdnZXJJZDtcbiAgICAgICAgdGhpcy5hdHRyVHJpZ2dlck5hbWUgPSByb3NUcmlnZ2VyLmF0dHJUcmlnZ2VyTmFtZTtcbiAgICAgICAgdGhpcy5hdHRyVXJsSW50ZXJuZXQgPSByb3NUcmlnZ2VyLmF0dHJVcmxJbnRlcm5ldDtcbiAgICAgICAgdGhpcy5hdHRyVXJsSW50cmFuZXQgPSByb3NUcmlnZ2VyLmF0dHJVcmxJbnRyYW5ldDtcbiAgICB9XG59XG4iXX0=