# Contributing to nova-trame

Thank you for considering contributing to nova-trame!
This document provides guidelines to help you contribute effectively and ensure a smooth process for everyone involved.

## Getting Started

To start contributing to this project, you will need a GitHub account. If you are unfamiliar with GitHub or version control,
then please consider reviewing the [GitHub docs](https://docs.github.com/).

## How to Contribute

### Reporting Bugs

If you find a bug in the project, please open an issue on GitHub with a clear and concise description. Make sure to include:

- Steps to reproduce the bug.
- Expected behavior.
- Actual behavior.
- Any relevant screenshots, logs, or stack traces.

### Suggesting Features

We welcome feature suggestions! To propose a new feature:

1. Open an issue on GitHub with the title "Feature Request: [Feature Name]".
2. Provide a detailed description of the proposed feature.
3. Explain why this feature would be useful for the project.
4. Include any relevant examples or mockups.

### Submitting Changes

If you'd like to contribute code changes, please follow our
[style guidelines](https://calvera.ornl.gov/docs/dev_guide/contributing/style_guidelines/).

## Code of Conduct

Please adhere to the project's [Code of Conduct](CODE_OF_CONDUCT.md) in all interactions.
