# coding: utf-8
from typing import Dict

lang_code2name: Dict[str, str] = {
    "aa": "afar",
    "ab": "abkhazian",
    "ae": "avestan",
    "af": "afrikaans",
    "ak": "akan",
    "am": "amharic",
    "an": "aragonese",
    "ar": "arabic",
    "as": "assamese",
    "av": "avarish",
    "ay": "aymara",
    "az": "azerbaijani",
    "ba": "bashkir",
    "be": "belarusian",
    "bg": "bulgarian",
    "bh": "bihari",
    "bi": "bislama",
    "bm": "bambara",
    "bn": "bengali",
    "bo": "tibetan",
    "br": "breton",
    "bs": "bosnian",
    "ca": "catalan",
    "ce": "chechen",
    "ch": "chamorro",
    "co": "corsican",
    "cr": "cree",
    "cs": "czech",
    "cu": "old_slavonic",
    "cv": "chuvash",
    "cy": "welsh",
    "da": "danish",
    "de": "german",
    "dv": "divehi",
    "dz": "dzongkha",
    "ee": "ewe",
    "el": "modern_greek",
    "en": "english",
    "eo": "esperanto",
    "es": "spanish",
    "et": "estonian",
    "eu": "basque",
    "fa": "farsi",
    "ff": "fulah",
    "fi": "finnish",
    "fj": "fijian",
    "fo": "faroese",
    "fr": "french",
    "fy": "frisian",
    "ga": "irish",
    "gd": "gaelic",
    "gl": "galician",
    "gn": "guarani",
    "gu": "gujarati",
    "gv": "manx_gaelic",
    "ha": "hausa",
    "he": "hebrew",
    "hi": "hindi",
    "ho": "hiri_motu",
    "hr": "croatian",
    "ht": "haitian",
    "hu": "hungarian",
    "hy": "armenian",
    "hz": "herero",
    "ia": "interlingua",
    "id": "indonesian",
    "ie": "interlingue",
    "ig": "igbo",
    "ii": "sichuan_yi",
    "ik": "inupiaq",
    "io": "ido",
    "is": "icelandic",
    "it": "italian",
    "iu": "inuktitut",
    "iw": "hebrew",
    "ja": "japanese",
    "jv": "javanese",
    "jw": "Javanese",
    "ka": "georgian",
    "kg": "kongo",
    "ki": "kikuyu",
    "kj": "kwanyama",
    "kk": "kazakh",
    "kl": "greenlandic",
    "km": "khmer",
    "kn": "kannada",
    "ko": "korean",
    "kr": "kanuri",
    "ks": "kashmiri",
    "ku": "kurdish",
    "kv": "komi",
    "kw": "cornish",
    "ky": "kyrgyz",
    "la": "latin",
    "lb": "luxembourgish",
    "lg": "luganda",
    "li": "limburgan",
    "ln": "lingala",
    "lo": "laotian",
    "lt": "lithuanian",
    "lu": "luba-katanga",
    "lv": "latvian",
    "mg": "malagasy",
    "mh": "marshallese",
    "mi": "maori",
    "mk": "macedonian",
    "ml": "malayalam",
    "mn": "mongolian",
    "mo": "moldavian",
    "mr": "marathi",
    "ms": "malay",
    "mt": "maltese",
    "my": "myanmar",
    "na": "nauran",
    "nb": "norwegian_bokmal",
    "nd": "north_ndebele",
    "ne": "nepali",
    "ng": "ndonga",
    "nl": "dutch",
    "nn": "norwegian_nynorsk",
    "no": "norwegian",
    "nr": "south_ndebele",
    "nv": "navajo",
    "ny": "chichewa",
    "oc": "occitan",
    "oj": "ojibwa",
    "om": "oromo",
    "or": "oriya",
    "os": "ossetian",
    "pa": "punjabi",
    "pi": "pali",
    "pl": "polish",
    "ps": "pashto",
    "pt": "portuguese",
    "qu": "quechua",
    "rm": "rhaeto-romance",
    "rn": "kirundi",
    "ro": "romanian",
    "ru": "russian",
    "rw": "kinyarwanda",
    "sa": "sanskrit",
    "sc": "sardinian",
    "sd": "sindhi",
    "se": "northern_sami",
    "sg": "sangho",
    "si": "sinhalese",
    "sk": "slovak",
    "sl": "slovenian",
    "sm": "samoan",
    "sn": "shona",
    "so": "somali",
    "sq": "albanian",
    "sr": "serbian",
    "ss": "swazi",
    "st": "sesotho",
    "su": "sundanese",
    "sv": "swedish",
    "sw": "swahili",
    "ta": "tamil",
    "te": "telugu",
    "tg": "tajiki",
    "th": "thai",
    "ti": "tigrinya",
    "tk": "turkmen",
    "tl": "tagalog",
    "tn": "setswana",
    "to": "tongan",
    "tr": "turkish",
    "ts": "tsonga",
    "tt": "tatar",
    "tw": "twi",
    "ty": "tahitian",
    "ug": "uighur",
    "uk": "ukrainian",
    "ur": "urdu",
    "uz": "uzbek",
    "ve": "venda",
    "vi": "vietnamese",
    "vo": "volapuk",
    "wa": "walloon",
    "wo": "wolof",
    "xh": "xhosa",
    "yi": "yiddish",
    "yo": "yoruba",
    "za": "zhuang",
    "zh": "chinese",
    "zu": "zulu",
}

LANG_IDENTIFIER2LANG_CODE: Dict[str, str] = {}
for code, name in lang_code2name.items():
    LANG_IDENTIFIER2LANG_CODE[code] = code
    LANG_IDENTIFIER2LANG_CODE[name] = code
