# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities, _tables

__all__ = ['SecretLibraryArgs', 'SecretLibrary']

@pulumi.input_type
class SecretLibraryArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 service_account_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 disable_check_in_enforcement: Optional[pulumi.Input[bool]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SecretLibrary resource.
        :param pulumi.Input[str] backend: The mount path for the AD backend.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_names: The names of all the service accounts that can be checked out from this set. These service accounts must already exist
               in Active Directory.
        :param pulumi.Input[bool] disable_check_in_enforcement: Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
        :param pulumi.Input[int] max_ttl: The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
        :param pulumi.Input[str] name: The name of the set of service accounts.
        :param pulumi.Input[int] ttl: The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "service_account_names", service_account_names)
        if disable_check_in_enforcement is not None:
            pulumi.set(__self__, "disable_check_in_enforcement", disable_check_in_enforcement)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The mount path for the AD backend.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="serviceAccountNames")
    def service_account_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The names of all the service accounts that can be checked out from this set. These service accounts must already exist
        in Active Directory.
        """
        return pulumi.get(self, "service_account_names")

    @service_account_names.setter
    def service_account_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "service_account_names", value)

    @property
    @pulumi.getter(name="disableCheckInEnforcement")
    def disable_check_in_enforcement(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
        """
        return pulumi.get(self, "disable_check_in_enforcement")

    @disable_check_in_enforcement.setter
    def disable_check_in_enforcement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_check_in_enforcement", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the set of service accounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


class SecretLibrary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable_check_in_enforcement: Optional[pulumi.Input[bool]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a SecretLibrary resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The mount path for the AD backend.
        :param pulumi.Input[bool] disable_check_in_enforcement: Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
        :param pulumi.Input[int] max_ttl: The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
        :param pulumi.Input[str] name: The name of the set of service accounts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_names: The names of all the service accounts that can be checked out from this set. These service accounts must already exist
               in Active Directory.
        :param pulumi.Input[int] ttl: The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretLibraryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SecretLibrary resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SecretLibraryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretLibraryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable_check_in_enforcement: Optional[pulumi.Input[bool]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            __props__['disable_check_in_enforcement'] = disable_check_in_enforcement
            __props__['max_ttl'] = max_ttl
            __props__['name'] = name
            if service_account_names is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_names'")
            __props__['service_account_names'] = service_account_names
            __props__['ttl'] = ttl
        super(SecretLibrary, __self__).__init__(
            'vault:ad/secretLibrary:SecretLibrary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            disable_check_in_enforcement: Optional[pulumi.Input[bool]] = None,
            max_ttl: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ttl: Optional[pulumi.Input[int]] = None) -> 'SecretLibrary':
        """
        Get an existing SecretLibrary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The mount path for the AD backend.
        :param pulumi.Input[bool] disable_check_in_enforcement: Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
        :param pulumi.Input[int] max_ttl: The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
        :param pulumi.Input[str] name: The name of the set of service accounts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_names: The names of all the service accounts that can be checked out from this set. These service accounts must already exist
               in Active Directory.
        :param pulumi.Input[int] ttl: The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["disable_check_in_enforcement"] = disable_check_in_enforcement
        __props__["max_ttl"] = max_ttl
        __props__["name"] = name
        __props__["service_account_names"] = service_account_names
        __props__["ttl"] = ttl
        return SecretLibrary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The mount path for the AD backend.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="disableCheckInEnforcement")
    def disable_check_in_enforcement(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
        """
        return pulumi.get(self, "disable_check_in_enforcement")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[int]:
        """
        The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the set of service accounts.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountNames")
    def service_account_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The names of all the service accounts that can be checked out from this set. These service accounts must already exist
        in Active Directory.
        """
        return pulumi.get(self, "service_account_names")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
        """
        return pulumi.get(self, "ttl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

