# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities, _tables

__all__ = ['AuthBackendRoleSecretIDArgs', 'AuthBackendRoleSecretID']

@pulumi.input_type
class AuthBackendRoleSecretIDArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[str],
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthBackendRoleSecretID resource.
        :param pulumi.Input[str] role_name: The name of the role to create the SecretID for.
        :param pulumi.Input[str] backend: Unique name of the auth backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidr_lists: If set, specifies blocks of IP addresses which can
               perform the login operation using this SecretID.
        :param pulumi.Input[str] metadata: A JSON-encoded string containing metadata in
               key-value pairs to be set on tokens issued with this SecretID.
        :param pulumi.Input[str] secret_id: The SecretID to be created. If set, uses "Push"
               mode.  Defaults to Vault auto-generating SecretIDs.
        :param pulumi.Input[str] wrapping_ttl: If set, the SecretID response will be
               [response-wrapped](https://www.vaultproject.io/docs/concepts/response-wrapping)
               and available for the duration specified. Only a single unwrapping of the
               token is allowed.
        """
        pulumi.set(__self__, "role_name", role_name)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if cidr_lists is not None:
            pulumi.set(__self__, "cidr_lists", cidr_lists)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if wrapping_ttl is not None:
            pulumi.set(__self__, "wrapping_ttl", wrapping_ttl)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[str]:
        """
        The name of the role to create the SecretID for.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the auth backend to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="cidrLists")
    def cidr_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If set, specifies blocks of IP addresses which can
        perform the login operation using this SecretID.
        """
        return pulumi.get(self, "cidr_lists")

    @cidr_lists.setter
    def cidr_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidr_lists", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON-encoded string containing metadata in
        key-value pairs to be set on tokens issued with this SecretID.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The SecretID to be created. If set, uses "Push"
        mode.  Defaults to Vault auto-generating SecretIDs.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="wrappingTtl")
    def wrapping_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        If set, the SecretID response will be
        [response-wrapped](https://www.vaultproject.io/docs/concepts/response-wrapping)
        and available for the duration specified. Only a single unwrapping of the
        token is allowed.
        """
        return pulumi.get(self, "wrapping_ttl")

    @wrapping_ttl.setter
    def wrapping_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wrapping_ttl", value)


class AuthBackendRoleSecretID(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages an AppRole auth backend SecretID in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/approle) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        approle = vault.AuthBackend("approle", type="approle")
        example = vault.app_role.AuthBackendRole("example",
            backend=approle.path,
            policies=[
                "default",
                "dev",
                "prod",
            ],
            role_name="test-role")
        id = vault.app_role.AuthBackendRoleSecretID("id",
            backend=approle.path,
            metadata=\"\"\"{
          "hello": "world"
        }

        \"\"\",
            role_name=example.role_name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: Unique name of the auth backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidr_lists: If set, specifies blocks of IP addresses which can
               perform the login operation using this SecretID.
        :param pulumi.Input[str] metadata: A JSON-encoded string containing metadata in
               key-value pairs to be set on tokens issued with this SecretID.
        :param pulumi.Input[str] role_name: The name of the role to create the SecretID for.
        :param pulumi.Input[str] secret_id: The SecretID to be created. If set, uses "Push"
               mode.  Defaults to Vault auto-generating SecretIDs.
        :param pulumi.Input[str] wrapping_ttl: If set, the SecretID response will be
               [response-wrapped](https://www.vaultproject.io/docs/concepts/response-wrapping)
               and available for the duration specified. Only a single unwrapping of the
               token is allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleSecretIDArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AppRole auth backend SecretID in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/approle) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        approle = vault.AuthBackend("approle", type="approle")
        example = vault.app_role.AuthBackendRole("example",
            backend=approle.path,
            policies=[
                "default",
                "dev",
                "prod",
            ],
            role_name="test-role")
        id = vault.app_role.AuthBackendRoleSecretID("id",
            backend=approle.path,
            metadata=\"\"\"{
          "hello": "world"
        }

        \"\"\",
            role_name=example.role_name)
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleSecretIDArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleSecretIDArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['backend'] = backend
            __props__['cidr_lists'] = cidr_lists
            __props__['metadata'] = metadata
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__['role_name'] = role_name
            __props__['secret_id'] = secret_id
            __props__['wrapping_ttl'] = wrapping_ttl
            __props__['accessor'] = None
            __props__['wrapping_accessor'] = None
            __props__['wrapping_token'] = None
        super(AuthBackendRoleSecretID, __self__).__init__(
            'vault:appRole/authBackendRoleSecretID:AuthBackendRoleSecretID',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[str]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            secret_id: Optional[pulumi.Input[str]] = None,
            wrapping_accessor: Optional[pulumi.Input[str]] = None,
            wrapping_token: Optional[pulumi.Input[str]] = None,
            wrapping_ttl: Optional[pulumi.Input[str]] = None) -> 'AuthBackendRoleSecretID':
        """
        Get an existing AuthBackendRoleSecretID resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: The unique ID for this SecretID that can be safely logged.
        :param pulumi.Input[str] backend: Unique name of the auth backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidr_lists: If set, specifies blocks of IP addresses which can
               perform the login operation using this SecretID.
        :param pulumi.Input[str] metadata: A JSON-encoded string containing metadata in
               key-value pairs to be set on tokens issued with this SecretID.
        :param pulumi.Input[str] role_name: The name of the role to create the SecretID for.
        :param pulumi.Input[str] secret_id: The SecretID to be created. If set, uses "Push"
               mode.  Defaults to Vault auto-generating SecretIDs.
        :param pulumi.Input[str] wrapping_accessor: The unique ID for the response-wrapped SecretID that can
               be safely logged.
        :param pulumi.Input[str] wrapping_token: The token used to retrieve a response-wrapped SecretID.
        :param pulumi.Input[str] wrapping_ttl: If set, the SecretID response will be
               [response-wrapped](https://www.vaultproject.io/docs/concepts/response-wrapping)
               and available for the duration specified. Only a single unwrapping of the
               token is allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessor"] = accessor
        __props__["backend"] = backend
        __props__["cidr_lists"] = cidr_lists
        __props__["metadata"] = metadata
        __props__["role_name"] = role_name
        __props__["secret_id"] = secret_id
        __props__["wrapping_accessor"] = wrapping_accessor
        __props__["wrapping_token"] = wrapping_token
        __props__["wrapping_ttl"] = wrapping_ttl
        return AuthBackendRoleSecretID(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[str]:
        """
        The unique ID for this SecretID that can be safely logged.
        """
        return pulumi.get(self, "accessor")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        Unique name of the auth backend to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="cidrLists")
    def cidr_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If set, specifies blocks of IP addresses which can
        perform the login operation using this SecretID.
        """
        return pulumi.get(self, "cidr_lists")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON-encoded string containing metadata in
        key-value pairs to be set on tokens issued with this SecretID.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        The name of the role to create the SecretID for.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[str]:
        """
        The SecretID to be created. If set, uses "Push"
        mode.  Defaults to Vault auto-generating SecretIDs.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="wrappingAccessor")
    def wrapping_accessor(self) -> pulumi.Output[str]:
        """
        The unique ID for the response-wrapped SecretID that can
        be safely logged.
        """
        return pulumi.get(self, "wrapping_accessor")

    @property
    @pulumi.getter(name="wrappingToken")
    def wrapping_token(self) -> pulumi.Output[str]:
        """
        The token used to retrieve a response-wrapped SecretID.
        """
        return pulumi.get(self, "wrapping_token")

    @property
    @pulumi.getter(name="wrappingTtl")
    def wrapping_ttl(self) -> pulumi.Output[Optional[str]]:
        """
        If set, the SecretID response will be
        [response-wrapped](https://www.vaultproject.io/docs/concepts/response-wrapping)
        and available for the duration specified. Only a single unwrapping of the
        token is allowed.
        """
        return pulumi.get(self, "wrapping_ttl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

