# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities, _tables

__all__ = ['SecretBackendCrlConfigArgs', 'SecretBackendCrlConfig']

@pulumi.input_type
class SecretBackendCrlConfigArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendCrlConfig resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        pulumi.set(__self__, "backend", backend)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)


class SecretBackendCrlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400,
            path="%s",
            type="pki")
        crl_config = vault.pki_secret.SecretBackendCrlConfig("crlConfig",
            backend=pki.path,
            disable=False,
            expiry="72h")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendCrlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400,
            path="%s",
            type="pki")
        crl_config = vault.pki_secret.SecretBackendCrlConfig("crlConfig",
            backend=pki.path,
            disable=False,
            expiry="72h")
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendCrlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendCrlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            __props__['disable'] = disable
            __props__['expiry'] = expiry
        super(SecretBackendCrlConfig, __self__).__init__(
            'vault:pkiSecret/secretBackendCrlConfig:SecretBackendCrlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            disable: Optional[pulumi.Input[bool]] = None,
            expiry: Optional[pulumi.Input[str]] = None) -> 'SecretBackendCrlConfig':
        """
        Get an existing SecretBackendCrlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["disable"] = disable
        __props__["expiry"] = expiry
        return SecretBackendCrlConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def disable(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter
    def expiry(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

