# Python Library – Copilot Instructions

## Code Style

Follow Google Python Style Guide:

- **Type hints**: Required on all public functions/methods
- **Docstrings**: Google style with Args/Returns/Raises sections
- **Self type**: Use `Self` for methods returning instance, not string annotations
- **File formatting**: Always end files with trailing newline, no extra whitespace

## Testing

- **Framework**: pytest (modify tests to match code changes, not reverse)
- **Focus**: Simplicity and precision - test happy path and critical edge cases only
- **Before adding**: Check if test already exists to avoid duplication
- **Validation**: Run tests after changes with `runTests` tool

## File Management

- **Never create**: IMPROVEMENTS.md, CHANGES.md, NOTES.md, TODO.md, ROADMAP.md
- **CHANGELOG.md**: Auto-generated by semantic-release - never edit manually
- **Work directly**: Edit source files, tests, and docs only

## Tool Usage

- **Always use tools**: Use `run_in_terminal`, `replace_string_in_file`, `runTests`
- **Never suggest**: Don't suggest commands - execute them

## Commit Messages

Use conventional commits with imperative mood and specific verbs:

- `feat(module):` `fix(module):` `docs:` `test:` `chore:`
- **Good verbs**: add, remove, replace, rename, move, extract, merge, split, convert
- **Bad verbs**: update, improve, enhance, refine, optimize, tweak, clarity, streamline

Examples:
- ✅ `fix(client): add AuthError for 401 responses`
- ❌ `fix(client): improve error handling`
