from typing import Any, Protocol, runtime_checkable


@runtime_checkable
class IProfiler(Protocol):
    pass


@runtime_checkable
class IAutomationLogger(Protocol):
    def debug(self, message: str) -> None: ...
    def info(self, message: str) -> None: ...
    def stat(self, message: str | dict[Any, Any]) -> None: ...
    def warning(self, message: str) -> None: ...
    def error(self, message: str) -> None: ...
    def exception(self, message: str) -> None: ...
    def critical(self, message: str) -> None: ...
    def capture_screenshot(
        self, filename: str | None = None, optimize_size: bool = False
    ) -> str: ...
    def capture_screenshot_selenium(self, driver: Any, filename: str | None = None) -> str: ...
    def group_by_prefix(self, prefix: str | None = None, sep: str | None = None) -> None: ...
    def insert_profiler(self, name: str, prof: IProfiler) -> None: ...
    def log_profilers(self) -> str: ...
